/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.utils.L;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public abstract class ViewAware
implements ImageAware {
    public static final String WARN_CANT_SET_DRAWABLE = "Can't set a drawable into view. You should call ImageLoader on UI thread for it.";
    public static final String WARN_CANT_SET_BITMAP = "Can't set a bitmap into view. You should call ImageLoader on UI thread for it.";
    protected Reference<View> viewRef;
    protected boolean checkActualViewSize;

    public ViewAware(View view) {
        this(view, true);
    }

    public ViewAware(View view, boolean checkActualViewSize) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        this.viewRef = new WeakReference<View>(view);
        this.checkActualViewSize = checkActualViewSize;
    }

    @Override
    public int getWidth() {
        View view = this.viewRef.get();
        if (view != null) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            int width = 0;
            if (this.checkActualViewSize && params != null && params.width != -2) {
                width = view.getWidth();
            }
            if (width <= 0 && params != null) {
                width = params.width;
            }
            return width;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        View view = this.viewRef.get();
        if (view != null) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            int height = 0;
            if (this.checkActualViewSize && params != null && params.height != -2) {
                height = view.getHeight();
            }
            if (height <= 0 && params != null) {
                height = params.height;
            }
            return height;
        }
        return 0;
    }

    @Override
    public ViewScaleType getScaleType() {
        return ViewScaleType.CROP;
    }

    @Override
    public View getWrappedView() {
        return this.viewRef.get();
    }

    @Override
    public boolean isCollected() {
        return this.viewRef.get() == null;
    }

    @Override
    public int getId() {
        View view = this.viewRef.get();
        return view == null ? super.hashCode() : view.hashCode();
    }

    @Override
    public boolean setImageDrawable(Drawable drawable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            View view = this.viewRef.get();
            if (view != null) {
                this.setImageDrawableInto(drawable, view);
                return true;
            }
        } else {
            L.w(WARN_CANT_SET_DRAWABLE, new Object[0]);
        }
        return false;
    }

    @Override
    public boolean setImageBitmap(Bitmap bitmap) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            View view = this.viewRef.get();
            if (view != null) {
                this.setImageBitmapInto(bitmap, view);
                return true;
            }
        } else {
            L.w(WARN_CANT_SET_BITMAP, new Object[0]);
        }
        return false;
    }

    protected abstract void setImageDrawableInto(Drawable var1, View var2);

    protected abstract void setImageBitmapInto(Bitmap var1, View var2);
}

