/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.save;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.gprinter.io.PortParameters;
import com.gprinter.save.DatabaseHelper;

public class PortParamDataBase {
    Context context;
    DatabaseHelper dbHelper = null;
    private static final String DEBUG_TAG = "LabelDataBase";
    private static final String PORT_PARAM_DATABASE = "GpLink_port_db1";
    private static final String TABLE_PORT_PARAM = "portparam";
    private static final String[] PORT_PARAM_QUERY = new String[]{"id", "open", "porttype", "btaddr", "usbname", "ip", "port"};

    public PortParamDataBase(Context context) {
        this.context = context;
        this.dbHelper = new DatabaseHelper(this.context, PORT_PARAM_DATABASE);
    }

    public void updataDatabase(int version) {
        this.dbHelper = new DatabaseHelper(this.context, PORT_PARAM_DATABASE, version);
    }

    public void insertPortParam(int id, PortParameters param) {
        ContentValues values = new ContentValues();
        Log.i((String)DEBUG_TAG, (String)"insertPortParam");
        values.put("id", Integer.valueOf(id));
        values.put("open", Boolean.valueOf(param.getPortOpenState()));
        values.put("porttype", Integer.valueOf(param.getPortType()));
        values.put("btaddr", param.getBluetoothAddr());
        values.put("usbname", param.getUsbDeviceName());
        values.put("ip", param.getIpAddr());
        values.put("port", Integer.valueOf(param.getPortNumber()));
        SQLiteDatabase sqliteDatabase = this.dbHelper.getWritableDatabase();
        sqliteDatabase.insert(TABLE_PORT_PARAM, null, values);
    }

    public void modifyPortParam(String id, PortParameters param) {
        Log.i((String)DEBUG_TAG, (String)"modifyPortParam");
        ContentValues values = new ContentValues();
        values.put("open", Boolean.valueOf(param.getPortOpenState()));
        SQLiteDatabase sqliteDatabase = this.dbHelper.getWritableDatabase();
        sqliteDatabase.update(TABLE_PORT_PARAM, values, "id=?", new String[]{id});
    }

    public PortParameters queryPortParamDataBase(String id) {
        PortParameters p = new PortParameters();
        SQLiteDatabase sqliteDatabase = this.dbHelper.getReadableDatabase();
        Log.i((String)DEBUG_TAG, (String)"queryPortParam");
        Cursor cursor = sqliteDatabase.query(TABLE_PORT_PARAM, PORT_PARAM_QUERY, "id=?", new String[]{id}, null, null, null);
        while (cursor.moveToNext()) {
            p.setPortType(cursor.getInt(cursor.getColumnIndex("porttype")));
            int i = cursor.getInt(cursor.getColumnIndex("open"));
            if (i == 0) {
                p.setPortOpenState(false);
            } else {
                p.setPortOpenState(true);
            }
            p.setBluetoothAddr(cursor.getString(cursor.getColumnIndex("btaddr")));
            p.setUsbDeviceName(cursor.getString(cursor.getColumnIndex("usbname")));
            p.setIpAddr(cursor.getString(cursor.getColumnIndex("ip")));
            p.setPortNumber(cursor.getInt(cursor.getColumnIndex("port")));
            Log.i((String)DEBUG_TAG, (String)("id " + cursor.getInt(cursor.getColumnIndex("id"))));
            Log.i((String)DEBUG_TAG, (String)("PortOpen " + p.getPortOpenState()));
            Log.i((String)DEBUG_TAG, (String)("PortType " + p.getPortType()));
            Log.i((String)DEBUG_TAG, (String)("BluetoothAddr " + p.getBluetoothAddr()));
            Log.i((String)DEBUG_TAG, (String)("UsbName " + p.getUsbDeviceName()));
            Log.i((String)DEBUG_TAG, (String)("Ip " + p.getIpAddr()));
            Log.i((String)DEBUG_TAG, (String)("Port " + p.getPortNumber()));
        }
        return p;
    }

    public void deleteDataBase(String id) {
        SQLiteDatabase sqliteDatabase = this.dbHelper.getWritableDatabase();
        Log.i((String)DEBUG_TAG, (String)"deleteDataBase");
        int rel = sqliteDatabase.delete(TABLE_PORT_PARAM, "id=?", new String[]{id});
        Log.i((String)DEBUG_TAG, (String)("rel  " + rel));
    }

    public void close() {
        if (this.dbHelper != null) {
            this.dbHelper.close();
        }
    }
}

