/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.service;

import android.annotation.SuppressLint;
import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.Base64;
import android.util.Log;
import android.widget.TextView;
import android.widget.Toast;
import com.gprinter.aidl.GpService;
import com.gprinter.command.GpCom;
import com.gprinter.io.GpDevice;
import com.gprinter.io.PortParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;

public class GpPrintService
extends Service {
    private static final String DEBUG_TAG = "GpPrintService";
    public static final String ACTION_PORT_OPEN = "action.port.open";
    public static final String ACTION_PORT_CLOSE = "action.port.close";
    public static final String ACTION_PRINT_TESTPAGE = "action.print.testpage";
    public static final String PRINTER_ID = "printer.id";
    public static final String PORT_TYPE = "port.type";
    public static final String USB_DEVICE_NAME = "usb.devicename";
    public static final String BLUETOOT_ADDR = "bluetooth.addr";
    public static final String IP_ADDR = "port.addr";
    public static final String PORT_NUMBER = "port.number";
    public static final String CONNECT_STATUS = "connect.status";
    public static final String PRINTER_CALLBACK = "printer.callback";
    public static final int MAX_PRINTER_CNT = 3;
    public static final String PRINTER_STATUS = "printer.status";
    public static final String ACTION_PRINTER_STATUS = "action.printer.status";
    private static GpDevice[] mDevice = new GpDevice[3];
    private Date NowDate = null;
    private Date TimeoutDate = null;
    private PowerManager.WakeLock wakeLock = null;
    private int mTimeout = 1000;
    private TextView mTime;
    GpService.Stub aidls = new GpService.Stub(){

        public int openPort(int PrinterId, int PortType, String DeviceName, int PortNumber) throws RemoteException {
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            int type = PortType;
            int id = PrinterId;
            Log.d((String)GpPrintService.DEBUG_TAG, (String)("port type " + type + "PrinterId " + id));
            switch (type) {
                case 2: {
                    String name = DeviceName;
                    Log.d((String)GpPrintService.DEBUG_TAG, (String)("port addr " + name));
                    retval = mDevice[id].openUSBPort((Context)GpPrintService.this, id, name, GpPrintService.this.mHandler);
                    break;
                }
                case 4: {
                    String addr = DeviceName;
                    retval = mDevice[id].openBluetoothPort(id, addr, GpPrintService.this.mHandler);
                    break;
                }
                case 3: {
                    int port = PortNumber;
                    String addr = DeviceName;
                    retval = mDevice[id].openEthernetPort(id, addr, port, GpPrintService.this.mHandler);
                }
            }
            return retval.ordinal();
        }

        public void closePort(int PrinterId) throws RemoteException {
            mDevice[PrinterId].closePort();
        }

        public int printeTestPage(int PrinterId) throws RemoteException {
            Log.d((String)GpPrintService.DEBUG_TAG, (String)"printeTestPage ");
            int rel = GpPrintService.this.printTestPage(PrinterId);
            return rel;
        }

        public int sendEscCommand(int PrinterId, String b64) throws RemoteException {
            Log.d((String)GpPrintService.DEBUG_TAG, (String)"sendEscCommand");
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            if (mDevice[PrinterId].getCommandType() == 0) {
                byte[] datas = Base64.decode((String)b64, (int)0);
                Vector<Byte> vector = new Vector<Byte>();
                byte[] byArray = datas;
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    vector.add(b);
                    ++n2;
                }
                retval = mDevice[PrinterId].sendDataImmediately(vector);
            } else {
                retval = GpCom.ERROR_CODE.FAILED;
            }
            return retval.ordinal();
        }

        public int sendTscCommand(int PrinterId, String b64) throws RemoteException {
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            if (mDevice[PrinterId].getCommandType() == 1) {
                byte[] datas = Base64.decode((String)b64, (int)0);
                Vector<Byte> vector = new Vector<Byte>();
                byte[] byArray = datas;
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    vector.add(b);
                    ++n2;
                }
                retval = mDevice[PrinterId].sendDataImmediately(vector);
            } else {
                retval = GpCom.ERROR_CODE.FAILED;
            }
            return retval.ordinal();
        }

        public int queryPrinterStatus(int PrinterId, int Timesout) throws RemoteException {
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            int status = 1;
            Byte[] esc = new Byte[]{(byte)16, (byte)4, (byte)2};
            Byte[] tsc = new Byte[]{(byte)27, (byte)33, (byte)63, (byte)13, (byte)10};
            Vector<Byte> data = null;
            Log.i((String)GpPrintService.DEBUG_TAG, (String)"queryPrintStatus ");
            if (mDevice[PrinterId].getConnectState() == 3) {
                int i;
                if (mDevice[PrinterId].getCommandType() == 0) {
                    data = new Vector<Byte>(esc.length);
                    i = 0;
                    while (i < esc.length) {
                        data.add(esc[i]);
                        ++i;
                    }
                } else {
                    data = new Vector(tsc.length);
                    i = 0;
                    while (i < tsc.length) {
                        data.add(tsc[i]);
                        ++i;
                    }
                }
                mDevice[PrinterId].mReceiveQueue.clear();
                retval = mDevice[PrinterId].sendDataImmediately(data);
                if (retval == GpCom.ERROR_CODE.SUCCESS) {
                    GpPrintService.this.NowDate = new Date();
                    GpPrintService.this.mTimeout = Timesout;
                    GpPrintService.this.TimeoutDate = new Date(GpPrintService.this.NowDate.getTime() + (long)GpPrintService.this.mTimeout);
                    while (GpPrintService.this.NowDate.before(GpPrintService.this.TimeoutDate)) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        GpPrintService.this.NowDate = new Date();
                    }
                    Log.d((String)GpPrintService.DEBUG_TAG, (String)("mDevice[PrinterId].queue.size()" + mDevice[PrinterId].mReceiveQueue.size()));
                    if (mDevice[PrinterId].mReceiveQueue.size() > 0) {
                        byte r = mDevice[PrinterId].mReceiveQueue.poll();
                        Log.i((String)GpPrintService.DEBUG_TAG, (String)("printer disconnect " + r));
                        status = 0;
                        if (mDevice[PrinterId].getCommandType() == 0) {
                            if ((r & 0x20) > 0) {
                                status |= 2;
                            }
                            if ((r & 4) > 0) {
                                status |= 4;
                            }
                            if ((r & 0x40) > 0) {
                                status |= 8;
                            }
                        } else {
                            if ((r & 4) > 0) {
                                status |= 2;
                            }
                            if ((r & 0x40) > 0) {
                                status |= 4;
                            }
                            if ((r & 0x80) > 0) {
                                status |= 8;
                            }
                        }
                    } else {
                        status = 16;
                    }
                } else {
                    mDevice[PrinterId].closePort();
                    status = 1;
                }
            } else {
                Log.i((String)GpPrintService.DEBUG_TAG, (String)"printer disconnect ");
                status = 1;
                mDevice[PrinterId].closePort();
            }
            return status;
        }

        public int getPrinterCommandType(int PrinterId) throws RemoteException {
            int type = mDevice[PrinterId].getCommandType();
            return type;
        }

        public int getPrinterConnectStatus(int PrinterId) throws RemoteException {
            int status = mDevice[PrinterId].getConnectState();
            return status;
        }
    };
    private BroadcastReceiver PortOperateBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (GpPrintService.ACTION_PORT_OPEN.equals(intent.getAction())) {
                Log.d((String)GpPrintService.DEBUG_TAG, (String)"PortOperateBroadcastReceiver action.port.open");
                GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
                int type = intent.getIntExtra(GpPrintService.PORT_TYPE, 0);
                int id = intent.getIntExtra(GpPrintService.PRINTER_ID, 0);
                Log.d((String)GpPrintService.DEBUG_TAG, (String)("port type " + type + "PrinterId " + id));
                switch (type) {
                    case 2: {
                        String name = intent.getStringExtra(GpPrintService.USB_DEVICE_NAME);
                        Log.d((String)GpPrintService.DEBUG_TAG, (String)("port addr " + name));
                        retval = mDevice[id].openUSBPort((Context)GpPrintService.this, id, name, GpPrintService.this.mHandler);
                        break;
                    }
                    case 4: {
                        String addr = intent.getStringExtra(GpPrintService.BLUETOOT_ADDR);
                        retval = mDevice[id].openBluetoothPort(id, addr, GpPrintService.this.mHandler);
                        break;
                    }
                    case 3: {
                        int port = intent.getIntExtra(GpPrintService.PORT_NUMBER, 9100);
                        String addr = intent.getStringExtra(GpPrintService.IP_ADDR);
                        retval = mDevice[id].openEthernetPort(id, addr, port, GpPrintService.this.mHandler);
                    }
                }
                if (retval != GpCom.ERROR_CODE.SUCCESS) {
                    GpPrintService.this.showError(retval);
                }
            } else if (GpPrintService.ACTION_PORT_CLOSE.equals(intent.getAction())) {
                int id = intent.getIntExtra(GpPrintService.PRINTER_ID, 0);
                Log.d((String)GpPrintService.DEBUG_TAG, (String)("PrinterId " + id));
                mDevice[id].closePort();
            } else if (GpPrintService.ACTION_PRINT_TESTPAGE.equals(intent.getAction())) {
                int id = intent.getIntExtra(GpPrintService.PRINTER_ID, 0);
                GpPrintService.this.printTestPage(id);
            } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(intent.getAction())) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                GpPrintService.this.disconnectBluetoothDevice(device.getAddress());
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(intent.getAction())) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                GpPrintService.this.disconnectUsbDevice(device.getDeviceName());
            }
        }
    };
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("MESSAGE_STATE_CHANGE: " + msg.arg1));
                    int type = msg.getData().getInt("device_status");
                    int id = msg.getData().getInt(GpPrintService.PRINTER_ID);
                    switch (type) {
                        case 3: {
                            GpPrintService.this.createAndRunCheckPrinterThread(id);
                            Log.i((String)GpPrintService.DEBUG_TAG, (String)"STATE_CONNECTED");
                            break;
                        }
                        case 2: {
                            Log.i((String)GpPrintService.DEBUG_TAG, (String)"STATE_CONNECTING");
                            break;
                        }
                        case 0: 
                        case 1: {
                            Log.i((String)GpPrintService.DEBUG_TAG, (String)"STATE_NONE");
                        }
                    }
                    Intent intent = new Intent("action.connect.status");
                    intent.putExtra(GpPrintService.CONNECT_STATUS, type);
                    intent.putExtra(GpPrintService.PRINTER_ID, id);
                    GpPrintService.this.sendBroadcast(intent);
                    break;
                }
                case 3: {
                    byte[] writeBuf = (byte[])msg.obj;
                    String writeMessage = new String(writeBuf);
                    Toast.makeText((Context)GpPrintService.this.getApplicationContext(), (CharSequence)("Connected to " + writeMessage), (int)0).show();
                    break;
                }
                case 2: {
                    int id = msg.getData().getInt(GpPrintService.PRINTER_ID);
                    int cnt = msg.getData().getInt("device.readcnt");
                    byte[] readBuf = msg.getData().getByteArray("device.read");
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("readMessage byte " + readBuf));
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("readMessage cnt" + cnt));
                    int i = 0;
                    while (i < cnt) {
                        if (readBuf[i] != 19) {
                            mDevice[id].mReceiveQueue.offer(readBuf[i]);
                        }
                        ++i;
                    }
                    break;
                }
                case 4: {
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("DeviceName: " + msg.getData().getString("device_name")));
                    break;
                }
                case 5: {
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("MessageToast: " + msg.getData().getString("toast")));
                    GpPrintService.this.messageBox(msg.getData().getString("toast"));
                }
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        Log.d((String)DEBUG_TAG, (String)"-Service onCreate-");
        this.acquireWakeLock();
        this.registerUserPortActionBroadcast();
        int i = 0;
        while (i < 3) {
            GpPrintService.mDevice[i] = new GpDevice();
            ++i;
        }
    }

    public void registerUserPortActionBroadcast() {
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_PORT_OPEN);
        filter.addAction(ACTION_PORT_CLOSE);
        filter.addAction(ACTION_PRINT_TESTPAGE);
        filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.registerReceiver(this.PortOperateBroadcastReceiver, filter);
    }

    public void onStart(Intent intent, int startId) {
        Log.d((String)DEBUG_TAG, (String)"-Service onStart-");
    }

    public void onDestroy() {
        Log.d((String)DEBUG_TAG, (String)"-Service onDestory-");
        this.unregisterReceiver(this.PortOperateBroadcastReceiver);
        this.releaseWakeLock();
        System.exit(0);
        super.onDestroy();
    }

    public boolean onUnbind(Intent intent) {
        Log.d((String)DEBUG_TAG, (String)"-Service onUnbind-");
        return super.onUnbind(intent);
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
        Log.d((String)DEBUG_TAG, (String)"-Service onRebind-");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)DEBUG_TAG, (String)"-Service onStartCommand-");
        return 1;
    }

    public IBinder onBind(Intent intent) {
        System.out.println("Service onBind");
        return this.aidls;
    }

    public boolean[] getConnectState() {
        boolean[] state = new boolean[3];
        int i = 0;
        while (i < 3) {
            state[i] = false;
            ++i;
        }
        i = 0;
        while (i < 3) {
            if (mDevice[i] != null) {
                Log.d((String)DEBUG_TAG, (String)("getConnectState " + i));
                if (mDevice[i].getConnectState() == 3) {
                    state[i] = true;
                }
            }
            ++i;
        }
        return state;
    }

    private void disconnectBluetoothDevice(String addr) {
        int i = 0;
        while (i < 3) {
            PortParameters p = mDevice[i].getPortParameters();
            if (p.getPortType() == 4 && p.getBluetoothAddr().equals(addr)) {
                mDevice[i].closePort();
                break;
            }
            ++i;
        }
    }

    private void disconnectUsbDevice(String name) {
        int i = 0;
        while (i < 3) {
            PortParameters p = mDevice[i].getPortParameters();
            if (p.getPortType() == 2 && p.getUsbDeviceName().equals(name)) {
                mDevice[i].closePort();
                break;
            }
            ++i;
        }
    }

    int printTestPage(int id) {
        GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
        Vector<Byte> TestPageData = null;
        if (mDevice[id].getConnectState() == 3) {
            if (mDevice[id].getCommandType() == 0) {
                TestPageData = this.getTestPageData("/esc.txt");
                Log.d((String)DEBUG_TAG, (String)"Send  ESC data ");
                retval = mDevice[id].sendDataImmediately(TestPageData);
            } else if (mDevice[id].getCommandType() == 1) {
                Log.d((String)DEBUG_TAG, (String)"Send TSC data ");
                TestPageData = this.getTestPageData("/tsc.txt");
                retval = mDevice[id].sendDataImmediately(TestPageData);
            } else {
                retval = GpCom.ERROR_CODE.INVALID_DEVICE_PARAMETERS;
            }
        } else {
            Log.d((String)DEBUG_TAG, (String)"Port is not connect ");
            retval = GpCom.ERROR_CODE.PORT_IS_NOT_OPEN;
        }
        return retval.ordinal();
    }

    Vector<Byte> getTestPageData(String root) {
        byte[] bs;
        byte[] data;
        block13: {
            data = null;
            Log.d((String)DEBUG_TAG, (String)("PrintTestPageButtonOnClickListener" + root));
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(root);
            bs = new byte[8192];
            int len = 0;
            try {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((len = in.read(bs)) != -1) {
                        out.write(bs, 0, len);
                    }
                    data = out.toByteArray();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Vector<Byte> TestPageData = new Vector<Byte>(data.length);
        int i = 0;
        while (i < data.length) {
            TestPageData.add(bs[i]);
            ++i;
        }
        return TestPageData;
    }

    boolean IsGprinter(int type, Vector<Byte> Data) {
        if (Data.size() == 0) {
            return false;
        }
        boolean rel = true;
        byte[] byArray = new byte[10];
        byArray[0] = 95;
        byArray[1] = 71;
        byArray[2] = 80;
        byArray[3] = 50;
        byArray[4] = 49;
        byArray[5] = 50;
        byArray[6] = 48;
        byArray[7] = 84;
        byArray[9] = 13;
        byte[] PRINTER_NAME_TABLE1 = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 95;
        byArray2[1] = 80;
        byArray2[2] = 84;
        byArray2[3] = 50;
        byArray2[4] = 56;
        byArray2[5] = 48;
        byArray2[7] = 13;
        byte[] PRINTER_NAME_TABLE2 = byArray2;
        byte[] byArray3 = new byte[9];
        byArray3[0] = 95;
        byArray3[1] = 71;
        byArray3[2] = 80;
        byArray3[3] = 53;
        byArray3[4] = 56;
        byArray3[5] = 57;
        byArray3[6] = 48;
        byArray3[8] = 13;
        byte[] PRINTER_NAME_TABLE3 = byArray3;
        byte[] byArray4 = new byte[10];
        byArray4[0] = 95;
        byArray4[1] = 71;
        byArray4[2] = 80;
        byArray4[3] = 53;
        byArray4[4] = 56;
        byArray4[5] = 49;
        byArray4[6] = 51;
        byArray4[7] = 48;
        byArray4[9] = 13;
        byte[] PRINTER_NAME_TABLE4 = byArray4;
        byte[] byArray5 = new byte[13];
        byArray5[0] = 95;
        byArray5[1] = 71;
        byArray5[2] = 80;
        byArray5[3] = 53;
        byArray5[4] = 56;
        byArray5[5] = 57;
        byArray5[6] = 48;
        byArray5[7] = 88;
        byArray5[8] = 73;
        byArray5[9] = 73;
        byArray5[10] = 73;
        byArray5[12] = 13;
        byte[] PRINTER_NAME_TABLE5 = byArray5;
        byte[] byArray6 = new byte[7];
        byArray6[0] = 95;
        byArray6[1] = 80;
        byArray6[2] = 114;
        byArray6[3] = 111;
        byArray6[4] = 53;
        byArray6[6] = 13;
        byte[] PRINTER_NAME_TABLE6 = byArray6;
        byte[] byArray7 = new byte[14];
        byArray7[0] = 95;
        byArray7[1] = 71;
        byArray7[2] = 80;
        byArray7[3] = 55;
        byArray7[4] = 54;
        byArray7[5] = 32;
        byArray7[6] = 83;
        byArray7[7] = 101;
        byArray7[8] = 114;
        byArray7[9] = 105;
        byArray7[10] = 101;
        byArray7[11] = 115;
        byArray7[13] = 13;
        byte[] PRINTER_NAME_TABLE7 = byArray7;
        byte[] byArray8 = new byte[13];
        byArray8[0] = 95;
        byArray8[1] = 71;
        byArray8[2] = 80;
        byArray8[3] = 45;
        byArray8[4] = 50;
        byArray8[5] = 51;
        byArray8[6] = 51;
        byArray8[7] = 48;
        byArray8[8] = 73;
        byArray8[9] = 86;
        byArray8[10] = 67;
        byArray8[12] = 13;
        byte[] PRINTER_NAME_TABLE8 = byArray8;
        byte[] byArray9 = new byte[12];
        byArray9[0] = 95;
        byArray9[1] = 71;
        byArray9[2] = 80;
        byArray9[3] = 45;
        byArray9[4] = 56;
        byArray9[5] = 48;
        byArray9[6] = 49;
        byArray9[7] = 50;
        byArray9[8] = 48;
        byArray9[9] = 73;
        byArray9[11] = 13;
        byte[] PRINTER_NAME_TABLE9 = byArray9;
        byte[] PRINTER_NAME_TABLE10 = new byte[]{71, 80, 75, 83, 45};
        byte[] byArray10 = new byte[12];
        byArray10[0] = 95;
        byArray10[1] = 71;
        byArray10[2] = 80;
        byArray10[3] = 45;
        byArray10[4] = 76;
        byArray10[5] = 56;
        byArray10[6] = 48;
        byArray10[7] = 49;
        byArray10[8] = 54;
        byArray10[9] = 48;
        byArray10[11] = 13;
        byte[] PRINTER_NAME_TABLE11 = byArray10;
        byte[] PRINTER_TYPE = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 50, 49, 50, 48, 13, 10};
        Log.v((String)"QQ", (String)(" isG " + Data));
        Log.i((String)DEBUG_TAG, (String)("Data.size " + Data.size()));
        if (type == 0) {
            int i = 0;
            while (i < PRINTER_NAME_TABLE1.length && i < Data.size()) {
                if (Data.get(i) != PRINTER_NAME_TABLE1[i]) {
                    rel = false;
                    break;
                }
                ++i;
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE2[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE3[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE4[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE5[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE6[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE7[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE8[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE9[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE10[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!rel) {
                rel = true;
                i = 0;
                while (i < Data.size()) {
                    if (Data.get(i) != PRINTER_NAME_TABLE11[i]) {
                        rel = false;
                        break;
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < Data.size()) {
                if (Data.get(i) != PRINTER_TYPE[i]) {
                    rel = false;
                    break;
                }
                ++i;
            }
        }
        Log.i((String)DEBUG_TAG, (String)("rel " + rel));
        return rel;
    }

    boolean IsGprinter(int type, int id) {
        Vector<Byte> Data = new Vector<Byte>();
        byte enddata = 0;
        enddata = type == 0 ? (byte)0 : 13;
        while (true) {
            if (GpPrintService.mDevice[id].mReceiveQueue.size() > 0) {
                byte data = GpPrintService.mDevice[id].mReceiveQueue.poll();
                Data.add(data);
                if (data != enddata) continue;
                break;
            }
            this.NowDate = new Date();
            this.TimeoutDate = new Date(this.NowDate.getTime() + (long)this.mTimeout);
            while (this.NowDate.before(this.TimeoutDate)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (GpPrintService.mDevice[id].mReceiveQueue.size() == 0) break;
        }
        boolean rel = this.IsGprinter(type, Data);
        return rel;
    }

    boolean checkGPrinter(int id, int commandType) {
        int i;
        Byte[] esc = new Byte[]{(byte)29, (byte)73, (byte)67};
        Byte[] tsc = new Byte[]{(byte)126, (byte)33, (byte)84, (byte)13, (byte)10};
        Vector<Byte> data = null;
        if (commandType == 0) {
            data = new Vector<Byte>(esc.length);
            i = 0;
            while (i < esc.length) {
                data.add(esc[i]);
                ++i;
            }
        } else {
            data = new Vector(tsc.length);
            i = 0;
            while (i < tsc.length) {
                data.add(tsc[i]);
                ++i;
            }
        }
        Log.i((String)DEBUG_TAG, (String)"SenData ");
        mDevice[id].sendDataImmediately(data);
        this.mTimeout = 1000;
        try {
            this.NowDate = new Date();
            this.TimeoutDate = new Date(this.NowDate.getTime() + (long)this.mTimeout);
            while (this.NowDate.before(this.TimeoutDate)) {
                Thread.sleep(10L);
                this.NowDate = new Date();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean rel = false;
        if (GpPrintService.mDevice[id].mReceiveQueue.size() > 0 && this.IsGprinter(commandType, id)) {
            rel = true;
        }
        return rel;
    }

    public void createAndRunCheckPrinterThread(final int id) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: while (true) {
                    try {
                        while (true) {
                            if (mDevice[id].getConnectState() == 3) {
                                Thread.sleep(1000L);
                                Log.i((String)GpPrintService.DEBUG_TAG, (String)"Check ESC Printer");
                                mDevice[id].mReceiveQueue.clear();
                                mDevice[id].setCommandType(0);
                                Intent intent = new Intent("action.connect.status");
                                intent.putExtra(GpPrintService.CONNECT_STATUS, 5);
                                intent.putExtra(GpPrintService.PRINTER_ID, id);
                                GpPrintService.this.sendBroadcast(intent);
                                Log.e((String)GpPrintService.DEBUG_TAG, (String)"connected");
                                if (!GpPrintService.this.checkGPrinter(id, 0)) {
                                    Log.i((String)GpPrintService.DEBUG_TAG, (String)"Check TSC Printer");
                                    if (!GpPrintService.this.checkGPrinter(id, 1)) {
                                        Intent i = new Intent("action.connect.status");
                                        intent.putExtra(GpPrintService.CONNECT_STATUS, 4);
                                        intent.putExtra(GpPrintService.PRINTER_ID, id);
                                        GpPrintService.this.sendBroadcast(intent);
                                        mDevice[id].closePort();
                                        break block2;
                                    }
                                    mDevice[id].setCommandType(1);
                                    Intent i2 = new Intent("action.connect.status");
                                    intent.putExtra(GpPrintService.CONNECT_STATUS, 5);
                                    intent.putExtra(GpPrintService.PRINTER_ID, id);
                                    GpPrintService.this.sendBroadcast(intent);
                                    break block2;
                                }
                                mDevice[id].setCommandType(0);
                                Intent i3 = new Intent("action.connect.status");
                                intent.putExtra(GpPrintService.CONNECT_STATUS, 5);
                                intent.putExtra(GpPrintService.PRINTER_ID, id);
                                GpPrintService.this.sendBroadcast(intent);
                                break block2;
                            }
                            if (mDevice[id].getConnectState() == 0) break block2;
                            Thread.sleep(200L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    private void messageBox(String err) {
    }

    private void showError(GpCom.ERROR_CODE retval) {
    }

    private void acquireWakeLock() {
        if (this.wakeLock == null) {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            this.wakeLock = pm.newWakeLock(0x20000001, ((Object)((Object)this)).getClass().getCanonicalName());
            if (this.wakeLock != null) {
                Log.i((String)"-wakeLock-", (String)"wakelock acquireWakeLock");
                this.wakeLock.acquire();
            }
        }
    }

    private void releaseWakeLock() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            Log.i((String)"-releaseWakeLock-", (String)"wakelock releaseWakeLock");
            this.wakeLock.release();
            this.wakeLock = null;
        }
    }
}

