/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.gprinter.command.GpCom;
import com.gprinter.io.GpPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.Vector;

public class BluetoothPort
extends GpPort {
    private static final String DEBUG_TAG = "BluetoothService";
    private static final UUID SERIAL_PORT_SERVICE_CLASS_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    private ConnectThread mConnectThread = null;
    private ConnectedThread mConnectedThread = null;
    BluetoothDevice mDevice = null;

    public BluetoothPort(int id, BluetoothDevice device, Handler handler) {
        this.mState = 0;
        this.mHandler = handler;
        this.mDevice = device;
        this.mPrinterId = id;
    }

    @Override
    public synchronized void connect() {
        Log.d((String)DEBUG_TAG, (String)("connect to: " + this.mDevice));
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(this.mDevice);
        this.mConnectThread.start();
        this.setState(2);
    }

    public synchronized void connected(BluetoothSocket socket, BluetoothDevice device) {
        Log.d((String)DEBUG_TAG, (String)"connected");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        Message msg = this.mHandler.obtainMessage(4);
        Bundle bundle = new Bundle();
        bundle.putInt("printer.id", this.mPrinterId);
        bundle.putString("device_name", device.getName());
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.setState(3);
    }

    @Override
    public synchronized void stop() {
        Log.d((String)DEBUG_TAG, (String)"stop");
        this.setState(0);
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GpCom.ERROR_CODE writeDataImmediately(Vector<Byte> data) {
        ConnectedThread r;
        GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
        BluetoothPort bluetoothPort = this;
        synchronized (bluetoothPort) {
            if (this.mState != 3) {
                return GpCom.ERROR_CODE.PORT_IS_NOT_OPEN;
            }
            r = this.mConnectedThread;
        }
        retval = r.writeDataImmediately(data);
        return retval;
    }

    private class ConnectThread
    extends Thread {
        private BluetoothSocket mmSocket;
        private final BluetoothDevice mmDevice;

        public ConnectThread(BluetoothDevice device) {
            this.mmDevice = device;
            BluetoothSocket tmp = null;
            try {
                tmp = device.createRfcommSocketToServiceRecord(SERIAL_PORT_SERVICE_CLASS_UUID);
            }
            catch (IOException e) {
                Log.e((String)BluetoothPort.DEBUG_TAG, (String)"create() failed", (Throwable)e);
            }
            this.mmSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.i((String)BluetoothPort.DEBUG_TAG, (String)"BEGIN mConnectThread");
            this.setName("ConnectThread");
            BluetoothPort.this.mAdapter.cancelDiscovery();
            try {
                this.mmSocket.connect();
            }
            catch (IOException e) {
                BluetoothPort.this.connectionFailed();
                try {
                    if (this.mmSocket != null) {
                        this.mmSocket.close();
                    }
                }
                catch (IOException e2) {
                    Log.e((String)BluetoothPort.DEBUG_TAG, (String)"unable to close() socket during connection failure", (Throwable)e2);
                }
                BluetoothPort.this.stop();
                return;
            }
            BluetoothPort bluetoothPort = BluetoothPort.this;
            synchronized (bluetoothPort) {
                BluetoothPort.this.mConnectThread = null;
            }
            BluetoothPort.this.connected(this.mmSocket, this.mmDevice);
        }

        public void cancel() {
            try {
                if (this.mmSocket != null) {
                    this.mmSocket.close();
                }
                this.mmSocket = null;
            }
            catch (IOException e) {
                Log.e((String)BluetoothPort.DEBUG_TAG, (String)"close() of connect socket failed", (Throwable)e);
                BluetoothPort.this.closePortFailed();
            }
        }
    }

    private class ConnectedThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        public ConnectedThread(BluetoothSocket socket) {
            Log.d((String)BluetoothPort.DEBUG_TAG, (String)"create ConnectedThread");
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)BluetoothPort.DEBUG_TAG, (String)"temp sockets not created", (Throwable)e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            Log.i((String)BluetoothPort.DEBUG_TAG, (String)"BEGIN mConnectedThread");
            BluetoothPort.this.mClosePort = false;
            while (!BluetoothPort.this.mClosePort) {
                try {
                    BluetoothPort.this.mmBytesAvailable = this.mmInStream.available();
                    if (BluetoothPort.this.mmBytesAvailable <= 0) continue;
                    byte[] ReceiveData = new byte[100];
                    int bytes = this.mmInStream.read(ReceiveData);
                    Log.d((String)BluetoothPort.DEBUG_TAG, (String)("bytes " + bytes));
                    if (bytes > 0) {
                        Message msg = BluetoothPort.this.mHandler.obtainMessage(2);
                        Bundle bundle = new Bundle();
                        bundle.putInt("printer.id", BluetoothPort.this.mPrinterId);
                        bundle.putInt("device.readcnt", bytes);
                        bundle.putByteArray("device.read", ReceiveData);
                        msg.setData(bundle);
                        BluetoothPort.this.mHandler.sendMessage(msg);
                        continue;
                    }
                    Log.e((String)BluetoothPort.DEBUG_TAG, (String)"disconnected");
                    BluetoothPort.this.connectionLost();
                    BluetoothPort.this.stop();
                    break;
                }
                catch (IOException e) {
                    BluetoothPort.this.connectionLost();
                    e.printStackTrace();
                    Log.e((String)BluetoothPort.DEBUG_TAG, (String)"disconnected", (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    Log.e((String)BluetoothPort.DEBUG_TAG, (String)"disconnected", (Throwable)e);
                }
            }
            Log.d((String)BluetoothPort.DEBUG_TAG, (String)"Closing Bluetooth work");
        }

        public void cancel() {
            try {
                BluetoothPort.this.mClosePort = true;
                this.mmOutStream.flush();
                if (this.mmSocket != null) {
                    this.mmSocket.close();
                }
            }
            catch (IOException e) {
                BluetoothPort.this.closePortFailed();
            }
        }

        public GpCom.ERROR_CODE writeDataImmediately(Vector<Byte> data) {
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            if (this.mmSocket != null && this.mmOutStream != null) {
                if (data != null && data.size() > 0) {
                    byte[] sendData = new byte[data.size()];
                    if (data.size() > 0) {
                        int i = 0;
                        while (i < data.size()) {
                            sendData[i] = data.get(i);
                            ++i;
                        }
                        try {
                            this.mmOutStream.write(sendData);
                            this.mmOutStream.flush();
                        }
                        catch (Exception e) {
                            Log.d((String)BluetoothPort.DEBUG_TAG, (String)("Exception occured while sending data immediately: " + e.getMessage()));
                            retval = GpCom.ERROR_CODE.FAILED;
                        }
                    }
                }
            } else {
                retval = GpCom.ERROR_CODE.PORT_IS_NOT_OPEN;
            }
            return retval;
        }
    }
}

