/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.call;

import android.content.Context;
import android.text.TextUtils;
import com.sina.weibo.sdk.call.CommonUtils;
import com.sina.weibo.sdk.call.WeiboIllegalParameterException;
import com.sina.weibo.sdk.call.WeiboNotInstalledException;
import java.util.HashMap;

public final class WeiboPageUtilsV2 {
    private WeiboPageUtilsV2() {
    }

    public static void postNewWeibo(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = null;
        uri = new StringBuilder("sinaweibo://sendweibo");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://sendweibo");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewNearbyPeople(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://nearbypeople");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://nearbypeople");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewNearbyWeibo(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://nearbyweibo");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://nearbyweibo");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewUserInfo(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null || TextUtils.isEmpty((CharSequence)params.get("uid")) && TextUtils.isEmpty((CharSequence)params.get("nick"))) {
            throw new WeiboIllegalParameterException("uid\u548cnick\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://userinfo");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://userinfo");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewUsertrends(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null || TextUtils.isEmpty((CharSequence)params.get("uid"))) {
            throw new WeiboIllegalParameterException("uid\u548cnick\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://usertrends");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://usertrends");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewPageInfo(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null || TextUtils.isEmpty((CharSequence)params.get("pageid"))) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pageinfo");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://pageinfo");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewPageProductList(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("pageid"))) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("cardid"))) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = -1;
        try {
            count = Integer.parseInt(params.get("count"));
        }
        catch (NumberFormatException e) {
            count = -1;
        }
        if (count < 0) {
            throw new WeiboIllegalParameterException("count\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pageproductlist");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://pageproductlist");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewPageUserList(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("pageid"))) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("cardid"))) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = -1;
        try {
            count = Integer.parseInt(params.get("count"));
        }
        catch (NumberFormatException e) {
            count = -1;
        }
        if (count < 0) {
            throw new WeiboIllegalParameterException("count\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pageuserlist");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://pageuserlist");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewPageWeiboList(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("pageid"))) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("cardid"))) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = -1;
        try {
            count = Integer.parseInt(params.get("count"));
        }
        catch (NumberFormatException e) {
            count = -1;
        }
        if (count < 0) {
            throw new WeiboIllegalParameterException("count\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pageweibolist");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://pageweibolist");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewPagePhotoList(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("pageid"))) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("cardid"))) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = -1;
        try {
            count = Integer.parseInt(params.get("count"));
        }
        catch (NumberFormatException e) {
            count = -1;
        }
        if (count < 0) {
            throw new WeiboIllegalParameterException("count\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pagephotolist");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://pagephotolist");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void viewPageDetailInfo(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("pageid"))) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("cardid"))) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pagedetailinfo");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://pagedetailinfo");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void openInWeiboBrowser(Context context, String url, String sinainternalbrowser, String extParam, String packageName) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new WeiboIllegalParameterException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(TextUtils.isEmpty((CharSequence)sinainternalbrowser) || "topnav".equals(sinainternalbrowser) || "default".equals(sinainternalbrowser) || "fullscreen".equals(sinainternalbrowser))) {
            throw new WeiboIllegalParameterException("sinainternalbrowser\u4e0d\u5408\u6cd5");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://browser");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("url", url);
        paramMap.put("sinainternalbrowser", sinainternalbrowser);
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        StringBuilder packageuri = null;
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            packageuri = new StringBuilder("sinaweibo://browser");
            if (paramMap != null) {
                packageuri.append(CommonUtils.buildUriQuery(paramMap));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), packageName);
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void displayInWeiboMap(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String mapUrl = "http://weibo.cn/dpool/ttt/maps.php?xy=%s,%s&amp;size=320x320&amp;offset=%s";
        String lon = "";
        String lat = "";
        String offset = "";
        if (params != null) {
            lon = params.get("longitude");
            lat = params.get("latitude");
            offset = params.get("offset");
        }
        String packageName = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageName = params.get("packagename");
        }
        if (params != null) {
            WeiboPageUtilsV2.openInWeiboBrowser(context, String.format(mapUrl, lon, lat, offset), "default", params.get("extparam"), packageName);
        }
    }

    public static void openQrcodeScanner(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://qrcode");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://qrcode");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }

    public static void weiboDetail(Context context, HashMap<String, String> params) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params == null) {
            throw new WeiboIllegalParameterException("mblogId(\u5fae\u535aid)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)params.get("mblogid"))) {
            throw new WeiboIllegalParameterException("mblogId(\u5fae\u535aid)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://detail");
        if (params != null) {
            uri.append(CommonUtils.buildUriQuery(params));
        }
        StringBuilder packageuri = null;
        if (params != null && !TextUtils.isEmpty((CharSequence)params.get("packagename"))) {
            packageuri = new StringBuilder("sinaweibo://detail");
            if (params != null) {
                packageuri.append(CommonUtils.buildUriQuery(params));
            }
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), params.get("packagename"));
        } else {
            CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString(), null);
        }
    }
}

