/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.call;

import android.content.Context;
import android.text.TextUtils;
import com.sina.weibo.sdk.call.CommonUtils;
import com.sina.weibo.sdk.call.Position;
import com.sina.weibo.sdk.call.WeiboIllegalParameterException;
import com.sina.weibo.sdk.call.WeiboNotInstalledException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public final class WeiboPageUtils {
    private WeiboPageUtils() {
    }

    public static void postNewWeibo(Context context, String content, String poiId, String poiName, Position position, String pageId, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://sendweibo");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            paramMap.put("content", URLEncoder.encode(content, "UTF-8").replaceAll("\\+", "%20"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        paramMap.put("poiid", poiId);
        paramMap.put("poiname", poiName);
        if (position != null) {
            paramMap.put("longitude", position.getStrLongitude());
            paramMap.put("latitude", position.getStrLatitude());
        }
        paramMap.put("pageid", pageId);
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewNearbyPeople(Context context, Position position, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://nearbypeople");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (position != null) {
            paramMap.put("longitude", position.getStrLongitude());
            paramMap.put("latitude", position.getStrLatitude());
            paramMap.put("offset", position.getStrOffset());
        }
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewNearbyWeibo(Context context, Position position, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://nearbyweibo");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (position != null) {
            paramMap.put("longitude", position.getStrLongitude());
            paramMap.put("latitude", position.getStrLatitude());
            paramMap.put("offset", position.getStrOffset());
        }
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewUserInfo(Context context, String uid, String nick, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)uid) && TextUtils.isEmpty((CharSequence)nick)) {
            throw new WeiboIllegalParameterException("uid\u548cnick\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://userinfo");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("uid", uid);
        paramMap.put("nick", nick);
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewUsertrends(Context context, String uid, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)uid)) {
            throw new WeiboIllegalParameterException("uid\u548cnick\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://usertrends");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("uid", uid);
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewPageInfo(Context context, String pageId, String title, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pageinfo");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pageid", pageId);
        paramMap.put("title", title);
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewPageProductList(Context context, String pageId, String cardId, String title, Integer count, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (count != null && count < 0) {
            throw new WeiboIllegalParameterException("count\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pageproductlist");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pageid", pageId);
        paramMap.put("cardid", cardId);
        paramMap.put("title", title);
        paramMap.put("page", "1");
        paramMap.put("count", String.valueOf(count));
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewPageUserList(Context context, String pageId, String cardId, String title, Integer count, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (count != null && count < 0) {
            throw new WeiboIllegalParameterException("count\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pageuserlist");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pageid", pageId);
        paramMap.put("cardid", cardId);
        paramMap.put("title", title);
        paramMap.put("page", "1");
        paramMap.put("count", String.valueOf(count));
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewPageWeiboList(Context context, String pageId, String cardId, String title, Integer count, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (count != null && count < 0) {
            throw new WeiboIllegalParameterException("count\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pageweibolist");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pageid", pageId);
        paramMap.put("cardid", cardId);
        paramMap.put("title", title);
        paramMap.put("page", "1");
        paramMap.put("count", String.valueOf(count));
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewPagePhotoList(Context context, String pageId, String cardId, String title, Integer count, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (count != null && count < 0) {
            throw new WeiboIllegalParameterException("count\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pagephotolist");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pageid", pageId);
        paramMap.put("cardid", cardId);
        paramMap.put("title", title);
        paramMap.put("page", "1");
        paramMap.put("count", String.valueOf(count));
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewPageDetailInfo(Context context, String pageId, String cardId, String title, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)pageId)) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            throw new WeiboIllegalParameterException("cardId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://pagedetailinfo");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pageid", pageId);
        paramMap.put("cardid", cardId);
        paramMap.put("title", title);
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void openInWeiboBrowser(Context context, String url, String sinainternalbrowser, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new WeiboIllegalParameterException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(TextUtils.isEmpty((CharSequence)sinainternalbrowser) || "topnav".equals(sinainternalbrowser) || "default".equals(sinainternalbrowser) || "fullscreen".equals(sinainternalbrowser))) {
            throw new WeiboIllegalParameterException("sinainternalbrowser\u4e0d\u5408\u6cd5");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://browser");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("url", url);
        paramMap.put("sinainternalbrowser", sinainternalbrowser);
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void displayInWeiboMap(Context context, Position position, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String mapUrl = "http://weibo.cn/dpool/ttt/maps.php?xy=%s,%s&amp;size=320x320&amp;offset=%s";
        String lon = "";
        String lat = "";
        String offset = "";
        if (position != null) {
            lon = position.getStrLongitude();
            lat = position.getStrLatitude();
            offset = position.getStrOffset();
        }
        WeiboPageUtils.openInWeiboBrowser(context, String.format(mapUrl, lon, lat, offset), "default", extParam);
    }

    public static void openQrcodeScanner(Context context, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://qrcode");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }

    public static void viewNearPhotoList(Context context, String longitude_X, String latitude_Y, Integer count, String extParam) throws WeiboNotInstalledException {
        WeiboPageUtils.viewPagePhotoList(context, "100101" + longitude_X + "_" + latitude_Y, "nearphoto", "\u5468\u8fb9\u70ed\u56fe", count, extParam);
    }

    public static void viewPoiPhotoList(Context context, String poiid, Integer count, String extParam) throws WeiboNotInstalledException {
        WeiboPageUtils.viewPagePhotoList(context, "100101" + poiid, "nearphoto", "\u5468\u8fb9\u70ed\u56fe", count, extParam);
    }

    public static void viewPoiPage(Context context, String longitude_X, String latitude_Y, String title, String extParam) throws WeiboNotInstalledException {
        WeiboPageUtils.viewPageInfo(context, "100101" + longitude_X + "_" + latitude_Y, title, extParam);
    }

    public static void weiboDetail(Context context, String mblogid, String extParam) throws WeiboNotInstalledException {
        if (context == null) {
            throw new WeiboIllegalParameterException("context\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mblogid)) {
            throw new WeiboIllegalParameterException("pageId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder uri = new StringBuilder("sinaweibo://detail");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("mblogid", mblogid);
        paramMap.put("extparam", extParam);
        uri.append(CommonUtils.buildUriQuery(paramMap));
        CommonUtils.openWeiboActivity(context, "android.intent.action.VIEW", uri.toString());
    }
}

