/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.cmd;

import android.text.TextUtils;
import com.sina.weibo.sdk.cmd.BaseCmd;
import com.sina.weibo.sdk.exception.WeiboException;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

class AppInstallCmd
extends BaseCmd {
    private long appVersion;
    private List<String> appPackages;
    private String appSign;
    private String downloadUrl;

    public AppInstallCmd() {
    }

    public AppInstallCmd(String jsonStr) throws WeiboException {
        super(jsonStr);
    }

    public AppInstallCmd(JSONObject JsonObj) {
        super(JsonObj);
    }

    @Override
    public void initFromJsonObj(JSONObject jsonObj) {
        super.initFromJsonObj(jsonObj);
        this.downloadUrl = jsonObj.optString("download_url");
        String appPackage = jsonObj.optString("app_package");
        if (!TextUtils.isEmpty((CharSequence)appPackage)) {
            this.appPackages = Arrays.asList(appPackage.split("\\|"));
        }
        this.appSign = jsonObj.optString("app_sign");
        this.appVersion = jsonObj.optLong("app_version");
    }

    public long getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(long appVersion) {
        this.appVersion = appVersion;
    }

    public List<String> getAppPackage() {
        return this.appPackages;
    }

    public void setAppPackage(List<String> appPackage) {
        this.appPackages = appPackage;
    }

    public String getAppSign() {
        return this.appSign;
    }

    public void setAppSign(String appSign) {
        this.appSign = appSign;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
}

