/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.QQPreferences;
import com.umeng.socialize.handler.UMTencentSSOHandler;
import com.umeng.socialize.media.QZoneShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class QZoneSsoHandler
extends UMTencentSSOHandler {
    private Activity mActivity;
    private Context context;
    private QZoneShareContent mShareContent;
    private QQPreferences qqPreferences;
    private static final String TAG = "QZoneSsoHandler";
    private IUiListener mUiListener = new IUiListener(){

        public void onError(UiError e) {
            QZoneSsoHandler.this.mAuthListener.onError(SHARE_MEDIA.QZONE, 0, null);
        }

        public void onCancel() {
            QZoneSsoHandler.this.mAuthListener.onCancel(SHARE_MEDIA.QZONE, 0);
        }

        public void onComplete(Object response) {
            QZoneSsoHandler.this.mAuthListener.onComplete(SHARE_MEDIA.QZONE, 0, null);
        }
    };

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.qqPreferences = new QQPreferences(context, SHARE_MEDIA.QQ.toString());
    }

    public boolean share(Activity activity, ShareContent content, UMShareListener listener) {
        if (listener != null) {
            this.mShareListener = listener;
        }
        if (!this.isInstall((Context)activity, this.getConfig())) {
            return false;
        }
        this.mShareContent = new QZoneShareContent(content);
        this.shareToQZone(activity, new QZoneShareContent(content));
        return false;
    }

    private void shareToQZone(Activity activity, QZoneShareContent content) {
        boolean flag;
        Bundle bundle = this.mShareContent.buildParamsQzone();
        bundle.putString("appName", this.getAppName());
        int type = bundle.getInt("req_type");
        ArrayList paths = bundle.getStringArrayList("imageUrl");
        String imagePath = null;
        if (paths != null && paths.size() > 0) {
            imagePath = (String)paths.get(0);
        }
        if (flag = this.isUploadImageAsync(imagePath, type)) {
            UMImage image = new UMImage((Context)activity, imagePath);
            UMAuthListener authListener = this.createAuthListener(bundle, image, activity);
            this.authorize(activity, authListener);
        } else {
            this.defaultQZoneShare(bundle, activity);
        }
    }

    public void deleteAuth(Context context, UMAuthListener listener) {
        this.mTencent.logout(context);
        if (this.qqPreferences != null) {
            this.qqPreferences.delete();
        }
        listener.onComplete(SHARE_MEDIA.QZONE, 1, null);
    }

    private UMAuthListener createAuthListener(final Bundle bundle, final UMImage image, final Activity activity) {
        return new UMAuthListener(){

            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                if (data != null && data.containsKey("uid")) {
                    String uid = data.get("uid");
                    QZoneSsoHandler.this.getBitmapUrl((UMediaObject)image, uid, new UMTencentSSOHandler.ObtainImageUrlListener(){

                        @Override
                        public void onComplete(String path) {
                            if (!TextUtils.isEmpty((CharSequence)path)) {
                                ArrayList<String> paths = new ArrayList<String>();
                                bundle.remove("imageUrl");
                                paths.add(path);
                                bundle.putStringArrayList("imageUrl", paths);
                                QZoneSsoHandler.this.defaultQZoneShare(bundle, activity);
                            } else {
                                QZoneSsoHandler.this.defaultQZoneShare(bundle, activity);
                                UMediaObject mediaObject = QZoneSsoHandler.this.mShareContent.getMedia();
                                int type = bundle.getInt("req_type");
                                if (!(QZoneSsoHandler.this.isClientInstalled((Context)activity) || mediaObject == null || mediaObject.getMediaType() != UMediaObject.MediaType.VEDIO && mediaObject.getMediaType() != UMediaObject.MediaType.MUSIC && type != 1)) {
                                    Log.e((String)QZoneSsoHandler.TAG, (String)"QQ\u7a7a\u95f4\u4e0a\u4f20\u56fe\u7247\u5931\u8d25\u5c06\u5bfc\u81f4\u65e0\u5ba2\u6237\u7aef\u5206\u4eab\u5931\u8d25\uff0c\u8bf7\u8bbe\u7f6e\u7f29\u7565\u56fe\u4e3aurl\u7c7b\u578b\u6216\u8005\u8f83\u5c0f\u7684\u672c\u5730\u56fe\u7247...");
                                }
                            }
                        }
                    });
                }
            }

            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
            }

            public void onCancel(SHARE_MEDIA platform, int action) {
            }
        };
    }

    private boolean isInstall(Context mContext, PlatformConfig.Platform p) {
        if (!this.mTencent.isSupportSSOLogin((Activity)mContext)) {
            StringBuilder msb = new StringBuilder();
            msb.append("\u8bf7\u5b89\u88c5");
            msb.append("qq");
            msb.append("\u5ba2\u6237\u7aef");
            Log.v((String)msb.toString());
            if (Config.IsToastTip) {
                Toast.makeText((Context)mContext, (CharSequence)msb, (int)1).show();
            }
            return false;
        }
        return true;
    }

    public boolean isSupportAuth() {
        return true;
    }

    public void authorize(Activity activity, UMAuthListener authListener) {
        this.mActivity = activity;
        if (!this.isInstall((Context)activity, this.getConfig())) {
            return;
        }
        this.mAuthListener = authListener;
        this.loginDeal();
    }

    private void loginDeal() {
        Log.i((String)TAG, (String)"QQ oauth login...");
        this.mTencent.login(this.mActivity, "all", this.getAuthlistener(this.mAuthListener));
    }

    private IUiListener getAuthlistener(UMAuthListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                if (e != null) {
                    Log.d((String)QZoneSsoHandler.TAG, (String)("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
                }
                QZoneSsoHandler.this.mAuthListener.onError(SHARE_MEDIA.QQ, 0, new Throwable("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
            }

            public void onCancel() {
                QZoneSsoHandler.this.mAuthListener.onCancel(SHARE_MEDIA.QQ, 0);
            }

            public void onComplete(Object response) {
                String status;
                SocializeUtils.safeCloseDialog((Dialog)QZoneSsoHandler.this.mProgressDialog);
                Bundle values = QZoneSsoHandler.this.parseOauthData(response);
                QZoneSsoHandler.this.qqPreferences.setAuthData(values).commit();
                QZoneSsoHandler.this.initOpenidAndToken((JSONObject)response);
                if (QZoneSsoHandler.this.mAuthListener != null) {
                    QZoneSsoHandler.this.mAuthListener.onComplete(SHARE_MEDIA.QQ, 0, QZoneSsoHandler.this.bundleTomap(values));
                }
                QZoneSsoHandler.this.uploadAuthData(values);
                if (values != null && TextUtils.isEmpty((CharSequence)(status = values.getString("ret")))) {
                    return;
                }
            }
        };
    }

    private void uploadAuthData(final Bundle bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlatformTokenUploadReq req = new PlatformTokenUploadReq(QZoneSsoHandler.this.getContext());
                req.addStringParams("to", "qq");
                req.addStringParams("usid", bundle.getString("uid"));
                req.addStringParams("access_token", bundle.getString("access_token"));
                req.addStringParams("refresh_token", bundle.getString("refresh_token"));
                req.addStringParams("expires_in", bundle.getString("expires_in"));
                req.addStringParams("app_id", QZoneSsoHandler.this.config.appId);
                req.addStringParams("app_secret", QZoneSsoHandler.this.config.appKey);
                PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                Log.e((String)("upload token resp = " + resp));
            }
        }).start();
    }

    private Map<String, String> bundleTomap(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        Set keys = bundle.keySet();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keys) {
            map.put(key, bundle.getString(key));
        }
        return map;
    }

    public void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString("access_token");
            String expires = jsonObject.getString("expires_in");
            String openId = jsonObject.getString("openid");
            if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                this.mTencent.setAccessToken(token, expires);
                this.mTencent.setOpenId(openId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRequestCode() {
        return 10104;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10104) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getmShareListener(this.mShareListener));
        }
        if (requestCode == 11101) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getAuthlistener(this.mAuthListener));
        }
    }

    public IUiListener getmShareListener(final UMShareListener mShareListener) {
        return new IUiListener(){

            public void onComplete(Object o) {
                mShareListener.onResult(SHARE_MEDIA.QZONE);
            }

            public void onError(UiError uiError) {
                mShareListener.onError(SHARE_MEDIA.QZONE, null);
            }

            public void onCancel() {
                mShareListener.onCancel(SHARE_MEDIA.QZONE);
            }
        };
    }

    private void defaultQZoneShare(final Bundle bundle, final Activity activity) {
        Log.d((String)TAG, (String)"invoke Tencent.shareToQzone method...");
        if (bundle != null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    QZoneSsoHandler.this.mTencent.shareToQzone(activity, bundle, QZoneSsoHandler.this.getmShareListener(QZoneSsoHandler.this.mShareListener));
                }
            });
        }
    }
}

