/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.open.t;

import android.content.Context;
import android.os.Bundle;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.common.BaseApi;
import com.tencent.open.utils.Global;
import com.tencent.open.utils.HttpUtils;
import com.tencent.tauth.IUiListener;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Weibo
extends BaseApi {
    public Weibo(Context context, QQAuth qQAuth, QQToken qQToken) {
        super(qQAuth, qQToken);
    }

    public Weibo(Context context, QQToken qQToken) {
        super(qQToken);
    }

    public void getWeiboInfo(IUiListener iUiListener) {
        Bundle bundle = this.composeCGIParams();
        BaseApi.TempRequestListener tempRequestListener = new BaseApi.TempRequestListener(iUiListener);
        HttpUtils.requestAsync(this.mToken, Global.getContext(), "user/get_info", bundle, "GET", tempRequestListener);
    }

    public void sendText(String string, IUiListener iUiListener) {
        Bundle bundle = this.composeCGIParams();
        bundle.putString("content", string == null ? "" : string);
        BaseApi.TempRequestListener tempRequestListener = new BaseApi.TempRequestListener(iUiListener);
        HttpUtils.requestAsync(this.mToken, Global.getContext(), "t/add_t", bundle, "POST", tempRequestListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPicText(String string, String string2, IUiListener iUiListener) {
        Object object;
        BaseApi.TempRequestListener tempRequestListener = new BaseApi.TempRequestListener(iUiListener);
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string2);
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new byte[1024];
            int n2 = 0;
            while ((n2 = ((InputStream)fileInputStream).read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            tempRequestListener.onIOException(iOException);
            return;
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                byteArrayOutputStream = null;
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                fileInputStream = null;
            }
        }
        object = this.composeCGIParams();
        object.putString("content", string == null ? "" : string);
        object.putByteArray("pic", byArray);
        HttpUtils.requestAsync(this.mToken, Global.getContext(), "t/add_pic_t", (Bundle)object, "POST", tempRequestListener);
    }

    public void nickTips(String string, int n2, IUiListener iUiListener) {
        Bundle bundle = this.composeCGIParams();
        bundle.putString("match", string == null ? "" : string);
        bundle.putString("reqnum", n2 + "");
        BaseApi.TempRequestListener tempRequestListener = new BaseApi.TempRequestListener(iUiListener);
        HttpUtils.requestAsync(this.mToken, Global.getContext(), "friends/match_nick_tips_weibo", bundle, "GET", tempRequestListener);
    }

    public void atFriends(int n2, IUiListener iUiListener) {
        Bundle bundle = this.composeCGIParams();
        bundle.putString("reqnum", n2 + "");
        BaseApi.TempRequestListener tempRequestListener = new BaseApi.TempRequestListener(iUiListener);
        HttpUtils.requestAsync(this.mToken, Global.getContext(), "friends/get_intimate_friends_weibo", bundle, "GET", tempRequestListener);
    }

    public void deleteText(String string, IUiListener iUiListener) {
        Bundle bundle = this.composeCGIParams();
        bundle.putString("id", string);
        BaseApi.TempRequestListener tempRequestListener = new BaseApi.TempRequestListener(iUiListener);
        HttpUtils.requestAsync(this.mToken, Global.getContext(), "t/del_t", bundle, "POST", tempRequestListener);
    }
}

