/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.tencent.open.t.Weibo;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.handler.QQPreferences;
import com.umeng.socialize.handler.UMTencentSSOHandler;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class QQwbHandler
extends UMTencentSSOHandler {
    private static final int REQUEST_ADD_PIC_T = 1001;
    private Weibo mWeibo = null;
    private Activity mActivity;
    private QQPreferences qqPreferences;

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.mWeibo = new Weibo(context, this.mTencent.getQQToken());
    }

    public void authorize(Activity act, UMAuthListener listener) {
        this.mActivity = act;
        if (!this.isInstall((Context)act, this.getConfig())) {
            return;
        }
        this.mAuthListener = listener;
        this.loginDeal();
    }

    private boolean isInstall(Context mContext, PlatformConfig.Platform p) {
        String packageName = "com.tencent.mobileqq";
        if (!DeviceConfig.isAppInstalled((String)packageName, (Context)mContext)) {
            StringBuilder msb = new StringBuilder();
            msb.append("\u8bf7\u5b89\u88c5");
            msb.append("qq");
            msb.append("\u5ba2\u6237\u7aef");
            Log.v((String)msb.toString());
            if (Config.IsToastTip) {
                Toast.makeText((Context)mContext, (CharSequence)msb, (int)1).show();
            }
            return false;
        }
        return true;
    }

    public boolean share(Activity activity, ShareContent content, UMShareListener listener) {
        if (content.mMedia != null && content.mMedia instanceof UMImage) {
            String filePath = null;
            if (((UMImage)content.mMedia).asFileImage() != null) {
                filePath = ((UMImage)content.mMedia).asFileImage().getPath();
            }
            if (filePath == null) {
                this.mWeibo.sendText(content.mText, this.getSharelistener(listener));
            } else {
                this.mWeibo.sendPicText(content.mText, filePath, this.getSharelistener(listener));
            }
        } else if (!TextUtils.isEmpty((CharSequence)content.mText)) {
            String text = content.mText;
            this.mWeibo.sendText(text, this.getSharelistener(listener));
        }
        return true;
    }

    public boolean QQisReady() {
        boolean ready = this.mTencent.isSessionValid() && this.mTencent.getQQToken().getOpenId() != null;
        return ready;
    }

    private IUiListener getSharelistener(final UMShareListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                Log.e((String)"xxxx qqerror");
                listener.onError(SHARE_MEDIA.TENCENT, null);
            }

            public void onCancel() {
                Log.e((String)"xxxx qqcancle");
                listener.onCancel(SHARE_MEDIA.TENCENT);
            }

            public void onComplete(Object response) {
                Log.e((String)"xxxx qqcomplete");
                listener.onResult(SHARE_MEDIA.TENCENT);
            }
        };
    }

    private Map<String, String> bundleTomap(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        Set keys = bundle.keySet();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keys) {
            map.put(key, bundle.getString(key));
        }
        return map;
    }

    private void loginDeal() {
        this.mTencent.login(this.mActivity, "all", this.getAuthlistener(this.mAuthListener));
    }

    public void deleteAuth(Context context, UMAuthListener listener) {
        this.mTencent.logout(context);
        if (this.qqPreferences != null) {
            this.qqPreferences.delete();
        }
        listener.onComplete(SHARE_MEDIA.TENCENT, 1, null);
    }

    private IUiListener getAuthlistener(UMAuthListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                if (e != null) {
                    Log.d((String)("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
                }
            }

            public void onCancel() {
            }

            public void onComplete(Object response) {
                String status;
                SocializeUtils.safeCloseDialog((Dialog)QQwbHandler.this.mProgressDialog);
                Bundle values = QQwbHandler.this.parseOauthData(response);
                QQwbHandler.this.qqPreferences = new QQPreferences((Context)QQwbHandler.this.mActivity, SHARE_MEDIA.QQ.toString());
                QQwbHandler.this.qqPreferences.setAuthData(values).commit();
                QQwbHandler.this.uploadAuthData(values);
                QQwbHandler.this.initOpenidAndToken((JSONObject)response);
                if (QQwbHandler.this.mAuthListener != null) {
                    QQwbHandler.this.mAuthListener.onComplete(SHARE_MEDIA.QQ, 0, QQwbHandler.this.bundleTomap(values));
                }
                if (values != null && TextUtils.isEmpty((CharSequence)(status = values.getString("ret")))) {
                    return;
                }
            }
        };
    }

    public boolean isSupportAuth() {
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10104) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getmShareListener(this.mShareListener));
        }
        if (requestCode == 11101) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getAuthlistener(this.mAuthListener));
        }
    }

    public IUiListener getmShareListener(final UMShareListener mShareListener) {
        return new IUiListener(){

            public void onComplete(Object o) {
                mShareListener.onResult(SHARE_MEDIA.QZONE);
            }

            public void onError(UiError uiError) {
                mShareListener.onError(SHARE_MEDIA.QZONE, null);
            }

            public void onCancel() {
                mShareListener.onCancel(SHARE_MEDIA.QZONE);
            }
        };
    }

    public void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString("access_token");
            String expires = jsonObject.getString("expires_in");
            String openId = jsonObject.getString("openid");
            if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                this.mTencent.setAccessToken(token, expires);
                this.mTencent.setOpenId(openId);
                Log.e((String)"xxxx write mTencent.getQQToken().getOpenId()=");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void uploadAuthData(final Bundle bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlatformTokenUploadReq req = new PlatformTokenUploadReq(QQwbHandler.this.getContext());
                req.addStringParams("to", "qq");
                req.addStringParams("usid", bundle.getString("uid"));
                req.addStringParams("access_token", bundle.getString("access_token"));
                req.addStringParams("refresh_token", bundle.getString("refresh_token"));
                req.addStringParams("expires_in", bundle.getString("expires_in"));
                req.addStringParams("app_id", QQwbHandler.this.config.appId);
                req.addStringParams("app_secret", QQwbHandler.this.config.appKey);
                PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                if (resp == null) {
                    Log.e((String)"fail to upload sina token");
                } else if (!resp.isOk()) {
                    Log.e((String)("fail to upload sina token = " + resp.mMsg));
                }
            }
        }).start();
    }
}

