/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.text.TextUtils;
import com.umeng.socialize.common.ImageFormat;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.net.utils.SocializeNetUtils;
import com.umeng.socialize.net.utils.SocializeProtocolConstants;
import com.umeng.socialize.utils.BitmapUtils;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class UMImage
extends BaseMediaObject {
    private ConfiguredConvertor h = null;
    private ConvertConfig i;

    public UMImage(Context context, File file) {
        this.a(context, file);
    }

    public UMImage(Context context, String string) {
        super(string);
        this.a((Context)new WeakReference<Context>(context).get(), string);
    }

    public UMImage(Context context, int n) {
        this.a(context, n);
    }

    public UMImage(Context context, byte[] byArray) {
        this.a(context, byArray);
    }

    public UMImage(Context context, Bitmap bitmap) {
        this.a(context, bitmap);
    }

    private void a(Context context, Object object) {
        if (object instanceof File) {
            this.h = new FileConvertor((File)object);
        } else if (object instanceof String) {
            this.h = new UrlConvertor((String)object);
        } else if (object instanceof Integer) {
            this.h = new ResConvertor(context, (Integer)object);
        } else if (object instanceof byte[]) {
            this.h = new BinaryConvertor((byte[])object);
        } else if (object instanceof Bitmap) {
            this.h = new BitmapConvertor((Bitmap)object);
        } else {
            throw new RuntimeException("Don't support type");
        }
        this.h.setConfig(new ConvertConfig(context));
    }

    @Override
    public byte[] toByte() {
        return this.asBinImage();
    }

    @Override
    public final Map<String, Object> toUrlExtraParams() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.isUrlMedia()) {
            hashMap.put(SocializeProtocolConstants.PROTOCOL_KEY_FURL, this.a);
            hashMap.put(SocializeProtocolConstants.PROTOCOL_KEY_FTYPE, (Object)this.getMediaType());
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] b(byte[] byArray) {
        Bitmap bitmap = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray2 = null;
        try {
            BitmapFactory.Options options = BitmapUtils.getBitmapOptions(byArray);
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
            byArray = null;
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (bitmap != null) {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                bitmap.recycle();
                bitmap = null;
                System.gc();
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byArray2;
    }

    @Override
    public UMediaObject.MediaType getMediaType() {
        return UMediaObject.MediaType.IMAGE;
    }

    public void resize(int n, int n2) {
    }

    @Override
    public boolean isMultiMedia() {
        return true;
    }

    public File asFileImage() {
        Log.e("xxxxx convor=" + this.h.asFile());
        return this.h == null ? null : this.h.asFile();
    }

    public String asUrlImage() {
        return this.h == null ? null : this.h.asUrl();
    }

    public byte[] asBinImage() {
        return this.h == null ? null : this.h.asBinary();
    }

    public Bitmap asBitmap() {
        return this.h == null ? null : this.h.asBitmap();
    }

    static Bitmap a(Drawable drawable) {
        int n = drawable.getIntrinsicWidth();
        int n2 = drawable.getIntrinsicHeight();
        Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, n, n2);
        drawable.draw(canvas);
        return bitmap;
    }

    static interface IImageConvertor {
        public File asFile();

        public String asUrl();

        public byte[] asBinary();

        public Bitmap asBitmap();
    }

    static class ConvertConfig {
        public float mImageSizeLimit = 2048.0f;
        private static final String a = "/umeng_cache/";
        private String b = "";

        public ConvertConfig(Context context) {
            try {
                this.b = context.getCacheDir().getCanonicalPath();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public ConvertConfig() {
        }

        public File getCache() throws IOException {
            String string;
            if (DeviceConfig.isSdCardWrittenable()) {
                string = Environment.getExternalStorageDirectory().getCanonicalPath();
            } else if (!TextUtils.isEmpty((CharSequence)this.b)) {
                string = this.b;
            } else {
                throw new IOException("dirpath is unknow");
            }
            File file = new File(string + a);
            if (file != null && !file.exists()) {
                file.mkdirs();
            }
            return file;
        }

        public File generateCacheFile(String string) throws IOException {
            BitmapUtils.cleanCache();
            File file = new File(this.getCache(), string);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            return file;
        }
    }

    static abstract class ConfiguredConvertor
    implements IImageConvertor {
        public ConvertConfig config = null;

        ConfiguredConvertor() {
        }

        public void setConfig(ConvertConfig convertConfig) {
            this.config = convertConfig;
        }
    }

    static class ResConvertor
    extends ConfiguredConvertor {
        private Context a;
        private int b = 0;

        public ResConvertor(Context context, int n) {
            this.a = context;
            this.b = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File asFile() {
            File file = null;
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                AssetFileDescriptor assetFileDescriptor = this.a.getResources().openRawResourceFd(this.b);
                fileInputStream = assetFileDescriptor.createInputStream();
                file = this.config.generateCacheFile(AesHelper.md5(fileInputStream.toString()));
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                while (fileInputStream.read(byArray) != -1) {
                    fileOutputStream.write(byArray);
                }
                fileOutputStream.flush();
                File file2 = file;
                return file2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return null;
        }

        @Override
        public String asUrl() {
            return null;
        }

        @Override
        public byte[] asBinary() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Resources resources = this.a.getResources();
            Drawable drawable = resources.getDrawable(this.b);
            Bitmap bitmap = UMImage.a(drawable);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public Bitmap asBitmap() {
            return BitmapFactory.decodeResource((Resources)this.a.getResources(), (int)this.b);
        }
    }

    static class BinaryConvertor
    extends ConfiguredConvertor {
        private ConvertConfig a = new ConvertConfig();
        private byte[] b;

        public BinaryConvertor(byte[] byArray) {
            this.b = byArray;
        }

        @Override
        public File asFile() {
            try {
                File file = this.a.generateCacheFile(this.getFileName());
                file = this.a(this.b, file);
                return file;
            }
            catch (IOException iOException) {
                Log.e("Sorry cannot setImage..[" + iOException.toString() + "]");
                return null;
            }
        }

        @Override
        public String asUrl() {
            return null;
        }

        @Override
        public byte[] asBinary() {
            return this.b;
        }

        @Override
        public Bitmap asBitmap() {
            if (this.b != null) {
                return BitmapFactory.decodeByteArray((byte[])this.b, (int)0, (int)this.b.length);
            }
            return null;
        }

        public String getFileName() {
            long l = System.currentTimeMillis();
            String string = AesHelper.md5(String.valueOf(l));
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File a(byte[] byArray, File file) {
            FilterOutputStream filterOutputStream = null;
            File file2 = file;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                filterOutputStream = new BufferedOutputStream(fileOutputStream);
                filterOutputStream.write(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return file2;
        }
    }

    static class UrlConvertor
    extends ConfiguredConvertor {
        private String a = null;

        public UrlConvertor(String string) {
            this.a = string;
        }

        @Override
        public File asFile() {
            File file = null;
            try {
                file = this.config.generateCacheFile(AesHelper.md5(this.a));
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = this.asBinary();
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return file;
        }

        @Override
        public String asUrl() {
            return this.a;
        }

        @Override
        public byte[] asBinary() {
            return SocializeNetUtils.getNetData(this.a);
        }

        @Override
        public Bitmap asBitmap() {
            byte[] byArray = this.asBinary();
            if (byArray != null) {
                return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            }
            return null;
        }
    }

    static class FileConvertor
    extends ConfiguredConvertor {
        private File a;

        public FileConvertor(File file) {
            this.a = file;
        }

        @Override
        public File asFile() {
            return this.a;
        }

        @Override
        public String asUrl() {
            return null;
        }

        @Override
        public byte[] asBinary() {
            return this.a(this.a);
        }

        @Override
        public Bitmap asBitmap() {
            return BitmapFactory.decodeFile((String)this.a.toString());
        }

        private byte[] a(File file) {
            if (file == null || !file.exists()) {
                return null;
            }
            byte[] byArray = FileConvertor.b(file);
            if (byArray != null && byArray.length > 0) {
                String string = ImageFormat.checkFormat(byArray);
                if (ImageFormat.FORMAT_NAMES[1].equals(string)) {
                    return byArray;
                }
                return UMImage.b(byArray);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] b(File file) {
            byte[] byArray = null;
            FileInputStream fileInputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[4096];
                while ((n = ((InputStream)fileInputStream).read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byte[] byArray3 = null;
                return byArray3;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return byArray;
        }
    }

    static class BitmapConvertor
    extends ConfiguredConvertor {
        private Bitmap a;

        public BitmapConvertor(Bitmap bitmap) {
            this.a = bitmap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File asFile() {
            OutputStream outputStream = null;
            try {
                long l = System.currentTimeMillis();
                File file = this.config.generateCacheFile(AesHelper.md5(this.a.toString()));
                outputStream = new FileOutputStream(file);
                int n = this.a.getRowBytes() * this.a.getHeight() / 1024;
                Log.d("### bitmap size = " + n + " KB");
                int n2 = 100;
                if ((float)n > this.config.mImageSizeLimit) {
                    n2 = (int)(this.config.mImageSizeLimit / (float)n * (float)n2);
                }
                Log.d("### \u538b\u7f29\u8d28\u91cf : " + n2);
                if (!this.a.isRecycled()) {
                    this.a.compress(Bitmap.CompressFormat.JPEG, n2, outputStream);
                }
                Log.d("##save bitmap " + file.getAbsolutePath());
                long l2 = System.currentTimeMillis();
                Log.d("#### \u56fe\u7247\u5e8f\u5217\u5316\u8017\u65f6 : " + (l2 - l) + " ms.");
                File file2 = file;
                return file2;
            }
            catch (Exception exception) {
                Log.e("Sorry cannot setImage..[" + exception.toString() + "]");
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }

        @Override
        public String asUrl() {
            return null;
        }

        @Override
        public byte[] asBinary() {
            return BitmapUtils.bitmap2Bytes(this.a);
        }

        @Override
        public Bitmap asBitmap() {
            return this.a;
        }
    }
}

