/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import com.sina.sso.RemoteSSO;
import com.sina.weibo.sdk.api.share.BaseRequest;
import com.sina.weibo.sdk.api.share.BaseResponse;
import com.sina.weibo.sdk.api.share.IWeiboShareAPI;
import com.sina.weibo.sdk.api.share.SendMultiMessageToWeiboRequest;
import com.sina.weibo.sdk.api.share.WeiboShareSDK;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.auth.sso.SsoHandler;
import com.sina.weibo.sdk.exception.WeiboException;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UMLocation;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.SinaPreferences;
import com.umeng.socialize.handler.UMAPIShareHandler;
import com.umeng.socialize.media.SinaShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.net.ShareFriendsRequest;
import com.umeng.socialize.net.ShareFriendsResponse;
import com.umeng.socialize.net.UserInfoRequest;
import com.umeng.socialize.net.UserInfoResponse;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.view.UMFriendListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SinaSsoHandler
extends UMAPIShareHandler {
    private static final String TAG = "SinaSsoHandler";
    private static final int REQUEST_CODE = 5659;
    private static final String waiturl = "sina2/main?uid";
    private String REDIRECT_URL = "http://sns.whalecloud.com";
    private PlatformConfig.SinaWeibo config = null;
    private SinaPreferences sinaPreferences;
    private UMShareListener shareListener;
    private AuthListener mAuthListener;
    private Context mContext;
    private SsoHandler mSsoHandler;
    private AuthInfo mAuthInfo;
    public static final String SCOPE = "email,direct_messages_read,direct_messages_write,friendships_groups_read,friendships_groups_write,statuses_to_me_read,follow_app_official_microblog,invitation_write";
    private IWeiboShareAPI mWeiboShareAPI;

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.mContext = context.getApplicationContext();
        this.config = (PlatformConfig.SinaWeibo)p;
        this.sinaPreferences = new SinaPreferences(this.mContext, "sina");
        this.mAuthInfo = new AuthInfo(context, ((PlatformConfig.SinaWeibo)p).appKey, this.REDIRECT_URL, SCOPE);
        this.mSsoHandler = new SsoHandler((Activity)context, this.mAuthInfo);
        this.mWeiboShareAPI = WeiboShareSDK.createWeiboAPI((Context)context, (String)this.config.appKey);
        this.mWeiboShareAPI.registerApp();
    }

    public IWeiboShareAPI getmWeiboShareAPI() {
        return this.mWeiboShareAPI;
    }

    public boolean isAuthorized() {
        return this.sinaPreferences.isAuthorized();
    }

    public boolean isInstall(Context mContext) {
        return this.isClientInstalled();
    }

    public boolean isAuthorize(Context mContext) {
        return this.isAuthorized();
    }

    public SHARE_MEDIA getPlatform() {
        return SHARE_MEDIA.SINA;
    }

    public String getUID() {
        return this.sinaPreferences.getUID();
    }

    public boolean isClientInstalled() {
        return this.mWeiboShareAPI.isWeiboAppInstalled();
    }

    public void authorize(Activity act, UMAuthListener listener) {
        this.mAuthListener = new AuthListener(listener);
        this.mSsoHandler.authorize((WeiboAuthListener)this.mAuthListener);
    }

    public void getPlatformInfo(final Activity act, final UMAuthListener listener) {
        if (this.sinaPreferences.getUID() != null) {
            UserInfoRequest req = new UserInfoRequest(this.getContext(), this.sinaPreferences.getUID());
            req.addStringParams("sns", "sina");
            UserInfoResponse resp = RestAPI.getUserInfo((UserInfoRequest)req);
            if (resp == null) {
                listener.onError(SHARE_MEDIA.SINA, 0, new Throwable("resp = null"));
            } else if (!resp.isOk()) {
                listener.onError(SHARE_MEDIA.SINA, 0, new Throwable("resp =" + resp.mMsg));
                Log.e((String)("xxxx error=" + resp.mMsg));
            } else {
                listener.onComplete(SHARE_MEDIA.SINA, 0, resp.mInfos);
            }
        } else {
            this.authorize(act, new UMAuthListener(){

                public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                    QueuedWork.runInBack((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SinaSsoHandler.this.getPlatformInfo(act, listener);
                        }
                    });
                }

                public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                    Log.e((String)"xxxx \u6388\u6743\u5931\u8d25");
                }

                public void onCancel(SHARE_MEDIA platform, int action) {
                    Log.e((String)"xxxx \u6388\u6743\u53d6\u6d88");
                }
            });
        }
    }

    public void deleteAuth(Context context, UMAuthListener listener) {
        this.sinaPreferences.delete();
        listener.onComplete(SHARE_MEDIA.SINA, 1, null);
    }

    public boolean share(Activity activity, ShareContent content, final UMShareListener listener) {
        SinaShareContent mSharecontent = new SinaShareContent(content);
        mSharecontent.SetContext((Context)activity);
        SendMultiMessageToWeiboRequest request = new SendMultiMessageToWeiboRequest();
        request.transaction = String.valueOf(System.currentTimeMillis());
        request.multiMessage = mSharecontent.getMessage();
        AuthInfo authInfo = new AuthInfo((Context)activity, this.config.appKey, this.REDIRECT_URL, SCOPE);
        String token = "";
        if (this.sinaPreferences != null) {
            token = this.sinaPreferences.getmAccessToken();
        }
        this.shareListener = listener;
        this.mWeiboShareAPI.sendRequest(activity, (BaseRequest)request, authInfo, token, new WeiboAuthListener(){

            public void onWeiboException(WeiboException arg0) {
                if (listener != null) {
                    listener.onError(SHARE_MEDIA.SINA, new Throwable((Throwable)arg0));
                }
            }

            public void onComplete(Bundle bundle) {
                if (listener != null) {
                    listener.onResult(SHARE_MEDIA.SINA);
                }
                SinaSsoHandler.this.sinaPreferences.setAuthData(bundle).commit();
            }

            public void onCancel() {
                if (listener != null) {
                    listener.onCancel(SHARE_MEDIA.SINA);
                }
            }
        });
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mSsoHandler != null) {
            this.mSsoHandler.authorizeCallBack(requestCode, resultCode, data);
        }
    }

    public boolean isSupportAuth() {
        return true;
    }

    public int getRequestCode() {
        return 5659;
    }

    public void setScope(String[] permissions) {
    }

    private boolean bindRemoteSSOService(Activity activity, String appkey) {
        SinaConnection serviceConnection = new SinaConnection(activity, appkey);
        Context ctx = activity.getApplicationContext();
        Intent intent = new Intent("com.sina.weibo.remotessoservice");
        List infos = activity.getPackageManager().queryIntentServices(intent, 0);
        ComponentName componentName = null;
        if (infos != null && infos.size() > 0) {
            ResolveInfo info = (ResolveInfo)infos.get(0);
            componentName = new ComponentName(info.serviceInfo.packageName, info.serviceInfo.name);
        }
        intent.setComponent(componentName);
        return ctx.bindService(intent, (ServiceConnection)serviceConnection, 1);
    }

    public void authorizeCallBack(int requestCode, int resultCode, Intent data) {
        if (requestCode != 5659) {
            return;
        }
        if (resultCode == -1) {
            String error = data.getStringExtra("error");
            if (error == null) {
                error = data.getStringExtra("error_type");
            }
            if (error != null) {
                if (error.equals("access_denied") || error.equals("OAuthAccessDeniedException")) {
                    Log.d((String)"Weibo-authorize", (String)"Login canceled by user.");
                    this.mAuthListener.onCancel();
                } else {
                    String description = data.getStringExtra("error_description");
                    if (description != null) {
                        error = error + ":" + description;
                    }
                    Log.d((String)"Weibo-authorize", (String)("Login failed: " + error));
                    SocializeException socializeException = new SocializeException(resultCode, error);
                }
            } else {
                this.mAuthListener.onComplete(data.getExtras());
            }
        } else if (resultCode == 0) {
            if (data != null) {
                Log.d((String)"Weibo-authorize", (String)("Login failed: " + data.getStringExtra("error")));
                StringBuilder msg = new StringBuilder();
                msg.append(data.getStringExtra("error"));
                msg.append(" : ");
                msg.append(data.getStringExtra("failing_url"));
                SocializeException socializeException = new SocializeException(data.getIntExtra("error_code", -1), msg.toString());
            } else {
                Log.d((String)"Weibo-authorize", (String)"Login canceled by user.");
                this.mAuthListener.onCancel();
            }
        }
    }

    public Bundle getEditable(ShareContent shareContent) {
        File file;
        Bundle bundle = new Bundle();
        bundle.putString("media", SHARE_MEDIA.SINA.toString());
        bundle.putString("title", "\u5206\u4eab\u5230\u65b0\u6d6a\u5fae\u535a");
        bundle.putString("txt", shareContent.mText);
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMImage && (file = ((UMImage)shareContent.mMedia).asFileImage()) != null) {
            bundle.putString("pic", file.getAbsolutePath());
        }
        bundle.putBoolean("at", true);
        bundle.putBoolean("location", true);
        if (shareContent.mFollow != null) {
            if (!this.sinaPreferences.Isfollow()) {
                bundle.putBoolean("follow_", true);
            } else {
                bundle.putBoolean("follow_", false);
            }
        } else {
            bundle.putBoolean("follow_", false);
        }
        return bundle;
    }

    protected void saveFollow() {
        super.saveFollow();
        this.sinaPreferences.setIsfollow(true);
    }

    public ShareContent getResult(ShareContent shareContent, Bundle bundle) {
        shareContent.mText = bundle.getString("txt");
        if (!bundle.getBoolean("follow_")) {
            shareContent.mFollow = null;
        }
        if (bundle.getString("pic") == null && shareContent.mMedia instanceof UMImage) {
            shareContent.mMedia = null;
        }
        if (bundle.getSerializable("location") != null) {
            shareContent.mLocation = (UMLocation)bundle.getSerializable("location");
        }
        return shareContent;
    }

    public void getfriend(final Activity act, final UMFriendListener listener) {
        String usid = this.sinaPreferences.getUID();
        if (usid == null) {
            UMAuthListener listenerauth = new UMAuthListener(){

                public void onComplete(SHARE_MEDIA platform, int action, final Map<String, String> data) {
                    QueuedWork.runInBack((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ShareFriendsRequest smfr = new ShareFriendsRequest((Context)act, SHARE_MEDIA.SINA, (String)data.get("uid"));
                            ShareFriendsResponse resp = RestAPI.queryFriendsList((ShareFriendsRequest)smfr);
                            if (resp == null) {
                                Log.e((String)"follow", (String)"resp = null");
                            } else if (!resp.isOk()) {
                                Log.e((String)"follow", (String)("follow fail e =" + resp.mMsg));
                            } else {
                                HashMap map = new HashMap();
                                map.put("friend", resp.mFriends);
                                map.put("json", resp.getJsonData());
                                listener.onComplete(SHARE_MEDIA.SINA, 2, map);
                            }
                        }
                    });
                }

                public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                    Log.e((String)"auth fail");
                }

                public void onCancel(SHARE_MEDIA platform, int action) {
                    Log.e((String)"auth cancle");
                }
            };
            this.authorize(act, listenerauth);
        } else {
            ShareFriendsRequest smfr = new ShareFriendsRequest((Context)act, SHARE_MEDIA.SINA, usid);
            ShareFriendsResponse resp = RestAPI.queryFriendsList((ShareFriendsRequest)smfr);
            if (resp == null) {
                listener.onError(SHARE_MEDIA.SINA, 2, new Throwable("resp = null"));
            } else if (!resp.isOk()) {
                listener.onError(SHARE_MEDIA.SINA, 2, new Throwable(resp.mMsg));
            } else {
                HashMap map = new HashMap();
                map.put("friend", resp.mFriends);
                map.put("json", resp.getJsonData());
                listener.onComplete(SHARE_MEDIA.SINA, 2, map);
            }
        }
    }

    public void onResponse(BaseResponse baseResponse) {
        switch (baseResponse.errCode) {
            case 0: {
                if (!this.isClientInstalled()) break;
                this.shareListener.onResult(SHARE_MEDIA.SINA);
                break;
            }
            case 1: {
                this.shareListener.onCancel(SHARE_MEDIA.SINA);
                break;
            }
            case 2: {
                this.shareListener.onError(SHARE_MEDIA.SINA, new Throwable(baseResponse.errMsg));
            }
        }
    }

    private Map<String, String> bundleTomap(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        Set keys = bundle.keySet();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keys) {
            map.put(key, bundle.getString(key));
        }
        return map;
    }

    private void uploadAuthData(final Bundle bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlatformTokenUploadReq req = new PlatformTokenUploadReq(SinaSsoHandler.this.getContext());
                req.addStringParams("to", "sina");
                req.addStringParams("usid", bundle.getString("uid"));
                req.addStringParams("access_token", bundle.getString("access_token"));
                req.addStringParams("refresh_token", bundle.getString("refresh_token"));
                req.addStringParams("expires_in", bundle.getString("expires_in"));
                req.addStringParams("app_id", ((SinaSsoHandler)SinaSsoHandler.this).config.appKey);
                req.addStringParams("app_secret", ((SinaSsoHandler)SinaSsoHandler.this).config.appSecret);
                PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                Log.e((String)("upload token resp = " + resp.mMsg));
            }
        }).start();
    }

    static class SinaConnection
    implements ServiceConnection {
        private static final String AUTH_SERVICE_NAME = "com.sina.weibo.business.RemoteSSOService";
        private static final String REDIRECT_URL = "http://sns.whalecloud.com";
        public boolean IsOK = false;
        public boolean IsConnected = false;
        public String PackageName = null;
        public String ActivityName = null;
        private WeakReference<Activity> mActivity = null;
        private String mAppId = null;
        private String[] mPermissions = null;
        private static final String WEIBO_SIGNATURE = "30820295308201fea00302010202044b4ef1bf300d06092a864886f70d010105050030818d310b300906035504061302434e3110300e060355040813074265694a696e673110300e060355040713074265694a696e67312c302a060355040a132353696e612e436f6d20546563686e6f6c6f677920284368696e612920436f2e204c7464312c302a060355040b132353696e612e436f6d20546563686e6f6c6f677920284368696e612920436f2e204c74643020170d3130303131343130323831355a180f32303630303130323130323831355a30818d310b300906035504061302434e3110300e060355040813074265694a696e673110300e060355040713074265694a696e67312c302a060355040a132353696e612e436f6d20546563686e6f6c6f677920284368696e612920436f2e204c7464312c302a060355040b132353696e612e436f6d20546563686e6f6c6f677920284368696e612920436f2e204c746430819f300d06092a864886f70d010101050003818d00308189028181009d367115bc206c86c237bb56c8e9033111889b5691f051b28d1aa8e42b66b7413657635b44786ea7e85d451a12a82a331fced99c48717922170b7fc9bc1040753c0d38b4cf2b22094b1df7c55705b0989441e75913a1a8bd2bc591aa729a1013c277c01c98cbec7da5ad7778b2fad62b85ac29ca28ced588638c98d6b7df5a130203010001300d06092a864886f70d0101050500038181000ad4b4c4dec800bd8fd2991adfd70676fce8ba9692ae50475f60ec468d1b758a665e961a3aedbece9fd4d7ce9295cd83f5f19dc441a065689d9820faedbb7c4a4c4635f5ba1293f6da4b72ed32fb8795f736a20c95cda776402099054fccefb4a1a558664ab8d637288feceba9508aa907fc1fe2b1ae5a0dec954ed831c0bea4";

        public SinaConnection(Activity activity, String appId) {
            this.mActivity = new WeakReference<Activity>(activity);
            this.mAppId = appId;
        }

        public void setPermissions(String[] permissions) {
            this.mPermissions = permissions;
        }

        public void onServiceDisconnected(ComponentName name) {
            this.IsConnected = false;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            this.IsConnected = true;
            RemoteSSO remoteSSOservice = RemoteSSO.Stub.asInterface((IBinder)service);
            try {
                this.PackageName = remoteSSOservice.getPackageName();
                this.ActivityName = remoteSSOservice.getActivityName();
                this.IsOK = this.startSingleSignOn((Activity)this.mActivity.get(), 5659);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        private boolean startSingleSignOn(Activity activity, int activityCode) {
            boolean didSucceed = true;
            Intent intent = new Intent();
            intent.setClassName(this.PackageName, this.ActivityName);
            intent.putExtra("appKey", this.mAppId);
            intent.putExtra("redirectUri", REDIRECT_URL);
            if (this.mPermissions != null && this.mPermissions.length > 0) {
                intent.putExtra("scope", TextUtils.join((CharSequence)",", (Object[])this.mPermissions));
            }
            if (!this.validateAppSignatureForIntent((Context)activity, intent)) {
                return false;
            }
            try {
                activity.startActivityForResult(intent, activityCode);
            }
            catch (ActivityNotFoundException e) {
                didSucceed = false;
            }
            if (this.IsConnected) {
                this.IsConnected = this.isServiceAlive((Context)activity);
                if (this.IsConnected) {
                    activity.getApplication().unbindService((ServiceConnection)this);
                }
            }
            return didSucceed;
        }

        private boolean validateAppSignatureForIntent(Context context, Intent intent) {
            PackageManager pm = context.getPackageManager();
            ResolveInfo resolveInfo = pm.resolveActivity(intent, 0);
            if (resolveInfo == null) {
                return false;
            }
            String packageName = resolveInfo.activityInfo.packageName;
            try {
                PackageInfo packageInfo = pm.getPackageInfo(packageName, 64);
                for (Signature signature : packageInfo.signatures) {
                    if (!WEIBO_SIGNATURE.equals(signature.toCharsString())) continue;
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
            return false;
        }

        private boolean isServiceAlive(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List serviceList = activityManager.getRunningServices(100);
            if (serviceList.size() <= 0) {
                return false;
            }
            for (int i = 0; i < serviceList.size(); ++i) {
                String serviceName = ((ActivityManager.RunningServiceInfo)serviceList.get((int)i)).service.getClassName();
                if (!serviceName.equals(AUTH_SERVICE_NAME)) continue;
                return true;
            }
            return false;
        }
    }

    class AuthListenerWrapper
    implements UMAuthListener {
        private UMAuthListener mListener = null;

        AuthListenerWrapper(UMAuthListener listener) {
            this.mListener = listener;
        }

        public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
        }

        public void onError(SHARE_MEDIA platform, int action, Throwable t) {
            if (this.mListener != null) {
                this.mListener.onError(platform, action, t);
            }
        }

        public void onCancel(SHARE_MEDIA platform, int action) {
            if (this.mListener != null) {
                this.mListener.onCancel(platform, action);
            }
        }
    }

    class AuthListener
    implements WeiboAuthListener {
        private UMAuthListener mListener = null;

        AuthListener(UMAuthListener listener) {
            this.mListener = listener;
        }

        public void onComplete(Bundle values) {
            SinaSsoHandler.this.sinaPreferences.setAuthData(values).commit();
            SinaSsoHandler.this.uploadAuthData(values);
            if (this.mListener != null) {
                this.mListener.onComplete(SHARE_MEDIA.SINA, 0, SinaSsoHandler.this.bundleTomap(values));
            }
        }

        public void onCancel() {
            if (this.mListener != null) {
                this.mListener.onCancel(SHARE_MEDIA.SINA, 0);
            }
        }

        public void onWeiboException(WeiboException e) {
            if (this.mListener != null) {
                this.mListener.onError(SHARE_MEDIA.SINA, 0, new Throwable((Throwable)e));
            }
        }
    }
}

