/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.BitmapUtils;
import com.umeng.socialize.utils.Log;
import java.util.HashMap;
import java.util.Map;

public class QQShareContent
extends SimpleShareContent {
    public int mShareType = 1;
    public Map<String, String> mExtraData = new HashMap<String, String>();
    protected static final String DEFAULT_TARGET_URL = "http://dev.umeng.com/";

    public QQShareContent(ShareContent shareContent) {
        super(shareContent);
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMusic) {
            this.setMusic((UMusic)shareContent.mMedia);
        }
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMVideo) {
            this.setVideo((UMVideo)shareContent.mMedia);
        }
    }

    public Bundle buildParams() {
        Bundle mParams = new Bundle();
        mParams.putString("summary", this.getText());
        if (this.getImage() != null && TextUtils.isEmpty((CharSequence)this.getText())) {
            this.mShareType = 5;
            this.buildImageParams(mParams);
        } else if (this.getVideo() != null || this.getMusic() != null) {
            this.mShareType = 2;
            this.buildAudioParams(mParams);
        } else {
            this.buildTextImageParams(mParams);
        }
        mParams.putInt("req_type", this.mShareType);
        if (TextUtils.isEmpty((CharSequence)this.getTitle())) {
            this.setTitle("\u5206\u4eab\u5230QQ");
        }
        if (TextUtils.isEmpty((CharSequence)this.getTargeturl())) {
            this.setTargeturl(DEFAULT_TARGET_URL);
        }
        mParams.putString("targetUrl", this.getTargeturl());
        mParams.putString("title", this.getTitle());
        if (Config.QQWITHQZONE == 1) {
            mParams.putInt("cflag", 1);
        } else if (Config.QQWITHQZONE == 2) {
            mParams.putInt("cflag", 2);
        }
        return mParams;
    }

    private void buildImageParams(Bundle bundle) {
        this.parseImage(this.getImage());
        String path = this.mExtraData.get("image_path_local");
        String urlPath = this.mExtraData.get("image_path_url");
        if (!TextUtils.isEmpty((CharSequence)path) && BitmapUtils.isFileExist((String)path)) {
            bundle.putString("imageLocalUrl", path);
        } else if (!TextUtils.isEmpty((CharSequence)urlPath)) {
            bundle.putString("imageUrl", urlPath);
        }
    }

    private void buildTextImageParams(Bundle bundle) {
        this.buildImageParams(bundle);
    }

    private void buildAudioParams(Bundle bundle) {
        UMusic TEMP = null;
        if (this.getMusic() != null) {
            TEMP = this.getMusic();
            this.parseMusic();
        } else if (this.getVideo() != null) {
            TEMP = this.getVideo();
            this.parseVideo();
        }
        String path = this.mExtraData.get("image_path_local");
        String urlPath = this.mExtraData.get("image_path_url");
        if (!TextUtils.isEmpty((CharSequence)path) && BitmapUtils.isFileExist((String)path)) {
            bundle.putString("imageLocalUrl", path);
        } else if (!TextUtils.isEmpty((CharSequence)urlPath)) {
            bundle.putString("imageUrl", urlPath);
        }
        bundle.putString("audio_url", TEMP.toUrl());
    }

    protected void parseImage(UMImage image) {
        if (image == null) {
            return;
        }
        String localPath = "";
        String urlPath = "";
        Log.v((String)"10.12", (String)("image=" + image));
        if (TextUtils.isEmpty((CharSequence)this.getTargeturl())) {
            if (!TextUtils.isEmpty((CharSequence)image.getTargetUrl())) {
                this.setTargeturl(image.getTargetUrl());
            } else {
                this.setTargeturl(image.toUrl());
            }
        }
        urlPath = image.toUrl();
        if (image.asFileImage() != null) {
            localPath = image.asFileImage().toString();
        }
        if (!BitmapUtils.isFileExist((String)localPath)) {
            localPath = "";
        }
        Log.v((String)"10.12", (String)("image path =" + localPath));
        this.mExtraData.put("image_path_local", localPath);
        this.mExtraData.put("image_path_url", urlPath);
    }

    protected void parseMusic() {
        UMusic music = this.getMusic();
        this.mExtraData.put("audio_url", music.toUrl());
        boolean empty = TextUtils.isEmpty((CharSequence)this.getTargeturl());
        if (!TextUtils.isEmpty((CharSequence)music.getThumb())) {
            this.mExtraData.put("image_path_url", music.getThumb());
        } else {
            this.parseImage(music.getThumbImage());
        }
        if (!TextUtils.isEmpty((CharSequence)music.getTitle())) {
            this.setTitle(music.getTitle());
        }
        if (empty) {
            if (!TextUtils.isEmpty((CharSequence)music.getTargetUrl())) {
                this.setTargeturl(music.getTargetUrl());
            } else {
                this.setTargeturl(music.toUrl());
            }
        }
    }

    protected void parseVideo() {
        UMVideo video = this.getVideo();
        this.mExtraData.put("audio_url", video.toUrl());
        boolean empty = TextUtils.isEmpty((CharSequence)this.getTargeturl());
        if (!TextUtils.isEmpty((CharSequence)video.getThumb())) {
            this.mExtraData.put("image_path_url", video.getThumb());
        } else {
            this.parseImage(video.getThumbImage());
        }
        if (!TextUtils.isEmpty((CharSequence)video.getTitle())) {
            this.setTitle(video.getTitle());
        }
        if (empty) {
            if (!TextUtils.isEmpty((CharSequence)video.getTargetUrl())) {
                this.setTargeturl(video.getTargetUrl());
            } else {
                this.setTargeturl(video.toUrl());
            }
        }
    }
}

