/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.tencent.connect.UserInfo;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.handler.QQPreferences;
import com.umeng.socialize.handler.UMTencentSSOHandler;
import com.umeng.socialize.media.QQShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.BitmapUtils;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class UMQQSsoHandler
extends UMTencentSSOHandler {
    private Activity mActivity;
    private boolean GOTO_SHARE_ACTIVITY = false;
    private static final String TAG = "UMQQSsoHandler";
    private IUiListener mShareListener;
    private QQShareContent msharecontent;
    private Bundle mParams;
    private QQPreferences qqPreferences;

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.qqPreferences = new QQPreferences(context, SHARE_MEDIA.QQ.toString());
    }

    public boolean share(Activity activity, ShareContent content, UMShareListener listener) {
        this.mParams = null;
        this.mActivity = activity;
        this.mShareListener = this.getSharelistener(listener);
        this.msharecontent = new QQShareContent(content);
        if (!this.isInstall((Context)activity, this.getConfig())) {
            return false;
        }
        this.shareToQQ((Context)activity);
        return false;
    }

    private IUiListener getSharelistener(final UMShareListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                Log.e((String)"xxxx qqerror");
                listener.onError(SHARE_MEDIA.QQ, null);
            }

            public void onCancel() {
                Log.e((String)"xxxx qqcancle");
                listener.onCancel(SHARE_MEDIA.QQ);
            }

            public void onComplete(Object response) {
                Log.e((String)"xxxx qqcomplete");
                listener.onResult(SHARE_MEDIA.QQ);
            }
        };
    }

    public boolean isAuthorize(Context mContext) {
        return this.qqPreferences.isAuthValid();
    }

    public void authorize(Activity act, UMAuthListener listener) {
        this.mActivity = act;
        if (!this.isInstall((Context)act, this.getConfig())) {
            return;
        }
        this.mAuthListener = listener;
        this.loginDeal();
    }

    private IUiListener getAuthlistener(UMAuthListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                if (e != null) {
                    Log.d((String)UMQQSsoHandler.TAG, (String)("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
                }
                UMQQSsoHandler.this.mAuthListener.onError(SHARE_MEDIA.QQ, 0, new Throwable("\u6388\u6743\u5931\u8d25! ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
            }

            public void onCancel() {
                UMQQSsoHandler.this.mAuthListener.onCancel(SHARE_MEDIA.QQ, 0);
            }

            public void onComplete(Object response) {
                int status;
                SocializeUtils.safeCloseDialog((Dialog)UMQQSsoHandler.this.mProgressDialog);
                Bundle values = UMQQSsoHandler.this.parseOauthData(response);
                UMQQSsoHandler.this.qqPreferences.setAuthData(values).commit();
                UMQQSsoHandler.this.initOpenidAndToken((JSONObject)response);
                if (UMQQSsoHandler.this.mAuthListener != null) {
                    UMQQSsoHandler.this.mAuthListener.onComplete(SHARE_MEDIA.QQ, 0, UMQQSsoHandler.this.bundleTomap(values));
                }
                UMQQSsoHandler.this.uploadAuthData(values);
                if (values != null && (status = Integer.valueOf(values.getString("ret")).intValue()) == 0) {
                    return;
                }
            }
        };
    }

    public boolean isInstall(Context mContext) {
        return this.mTencent.isSupportSSOLogin((Activity)mContext);
    }

    public void deleteAuth(Context context, UMAuthListener listener) {
        this.mTencent.logout(context);
        this.qqPreferences.delete();
        listener.onComplete(SHARE_MEDIA.QQ, 1, null);
    }

    private boolean isInstall(Context mContext, PlatformConfig.Platform p) {
        if (!this.mTencent.isSupportSSOLogin((Activity)mContext)) {
            StringBuilder msb = new StringBuilder();
            msb.append("\u8bf7\u5b89\u88c5");
            msb.append(ResContainer.getString((Context)mContext, (String)p.getName().toSnsPlatform().mShowWord));
            msb.append("\u5ba2\u6237\u7aef");
            Log.v((String)msb.toString());
            if (Config.IsToastTip) {
                Toast.makeText((Context)mContext, (CharSequence)msb, (int)1).show();
            }
            return false;
        }
        return true;
    }

    public boolean isSupportAuth() {
        return true;
    }

    private void loginDeal() {
        Log.i((String)TAG, (String)"QQ oauth login...");
        this.mTencent.login(this.mActivity, "all", this.getAuthlistener(this.mAuthListener));
    }

    public void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString("access_token");
            String expires = jsonObject.getString("expires_in");
            String openId = jsonObject.getString("openid");
            if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                this.mTencent.setAccessToken(token, expires);
                this.mTencent.setOpenId(openId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void uploadAuthData(final Bundle bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlatformTokenUploadReq req = new PlatformTokenUploadReq(UMQQSsoHandler.this.getContext());
                req.addStringParams("to", "qq");
                req.addStringParams("usid", bundle.getString("uid"));
                req.addStringParams("access_token", bundle.getString("access_token"));
                req.addStringParams("refresh_token", bundle.getString("refresh_token"));
                req.addStringParams("expires_in", bundle.getString("expires_in"));
                req.addStringParams("app_id", UMQQSsoHandler.this.config.appId);
                req.addStringParams("app_secret", UMQQSsoHandler.this.config.appKey);
                PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                Log.e((String)("upload token resp = " + resp));
            }
        }).start();
    }

    private Map<String, String> bundleTomap(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        Set keys = bundle.keySet();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keys) {
            map.put(key, bundle.getString(key));
        }
        return map;
    }

    public void canOpenShareActivity(boolean val) {
        this.GOTO_SHARE_ACTIVITY = val;
    }

    private void gotoShare() {
    }

    public void shareToQQ(Context mContext) {
        if (this.validTencent()) {
            String path = this.msharecontent.mExtraData.get("image_path_local");
            if (this.isLoadImageAsync(mContext)) {
                String url = this.msharecontent.mExtraData.get("image_path_url");
                this.loadImage(mContext, url);
                return;
            }
            if (this.isUploadImageAsync(path, this.msharecontent.mShareType, mContext)) {
                UMImage image = new UMImage(mContext, new File(path));
                Log.w((String)TAG, (String)"\u672a\u5b89\u88c5QQ\u5ba2\u6237\u7aef\u7684\u60c5\u51b5\u4e0b\uff0cQQ\u4e0d\u652f\u6301\u97f3\u9891\uff0c\u56fe\u6587\u662f\u4e3a\u672c\u5730\u56fe\u7247\u7684\u5206\u4eab\u3002\u6b64\u65f6\u5c06\u4e0a\u4f20\u672c\u5730\u56fe\u7247\u5230\u76f8\u518c\uff0c\u8bf7\u786e\u4fdd\u5728QQ\u4e92\u8054\u7533\u8bf7\u4e86upload_pic\u6743\u9650.");
                UMAuthListener authListener = this.createUploadAuthListener(image);
                this.authorize(this.mActivity, authListener);
                return;
            }
            this.defaultShareToQQ(this.msharecontent);
        } else {
            Log.d((String)TAG, (String)"QQ\u5e73\u53f0\u8fd8\u6ca1\u6709\u6388\u6743");
            this.authorize(this.mActivity, null);
        }
    }

    private UMAuthListener createUploadAuthListener(final UMImage image) {
        return new UMAuthListener(){

            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                if (data != null && data.containsKey("uid") && !TextUtils.isEmpty((CharSequence)image.asUrlImage())) {
                    UMQQSsoHandler.this.mParams.putString("imageUrl", image.asUrlImage());
                    UMQQSsoHandler.this.mParams.remove("imageLocalUrl");
                    UMQQSsoHandler.this.defaultShareToQQ(UMQQSsoHandler.this.msharecontent);
                }
            }

            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
            }

            public void onCancel(SHARE_MEDIA platform, int action) {
            }
        };
    }

    protected boolean isUploadImageAsync(String imagePath, int type, Context context) {
        boolean isLocalImage;
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            return false;
        }
        SHARE_MEDIA platform = this.config.getName();
        boolean hasClient = this.isClientInstalled(context);
        boolean bl = isLocalImage = !imagePath.startsWith("http://") && !imagePath.startsWith("https://");
        if (!hasClient && isLocalImage) {
            if (platform == SHARE_MEDIA.QQ && (type == 2 || type == 1)) {
                return true;
            }
            if (platform == SHARE_MEDIA.QZONE && (type == 1 || type == 2)) {
                return true;
            }
        }
        return false;
    }

    private boolean isLoadImageAsync(Context context) {
        String urlPath = this.msharecontent.mExtraData.get("image_path_url");
        String localPath = this.msharecontent.mExtraData.get("image_path_local");
        return this.msharecontent.mShareType == 5 && this.isClientInstalled(context) && !TextUtils.isEmpty((CharSequence)urlPath) && TextUtils.isEmpty((CharSequence)localPath);
    }

    private void loadImage(Context context, String imageUrlPath) {
        BitmapUtils.getBitmapFromFile((String)imageUrlPath);
        SocializeUtils.safeCloseDialog((Dialog)this.mProgressDialog);
        String localPath = BitmapUtils.getFileName((String)imageUrlPath);
        this.mParams.putString("imageLocalUrl", localPath);
        this.mParams.remove("imageUrl");
        this.defaultShareToQQ(this.msharecontent);
    }

    private void defaultShareToQQ(QQShareContent shareContent) {
        this.mParams = this.msharecontent.buildParams();
        this.mParams.putString("appName", this.getAppName());
        Log.d((String)TAG, (String)"invoke Tencent.shareToQQ method...");
        if (this.mParams != null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMQQSsoHandler.this.mTencent.shareToQQ(UMQQSsoHandler.this.mActivity, UMQQSsoHandler.this.mParams, UMQQSsoHandler.this.mShareListener);
                    Log.e((String)("xxxx mpara=" + UMQQSsoHandler.this.mParams));
                }
            });
        }
    }

    public int getRequestCode() {
        return 10103;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10103) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.mShareListener);
        }
        if (requestCode == 11101) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getAuthlistener(this.mAuthListener));
        }
    }

    public void getPlatformInfo(Activity act, final UMAuthListener listener) {
        if (this.isAuthorize((Context)act)) {
            try {
                String token = this.qqPreferences.getmAccessToken();
                UMQQSsoHandler uMQQSsoHandler = this;
                String expires = uMQQSsoHandler.qqPreferences.getExpiresIn();
                String openId = this.qqPreferences.getmUID();
                if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                    this.mTencent.setAccessToken(token, expires);
                    this.mTencent.setOpenId(openId);
                }
            }
            catch (Exception token) {
                // empty catch block
            }
        }
        UserInfo userInfo = new UserInfo((Context)act, this.mTencent.getQQToken());
        userInfo.getUserInfo(new IUiListener(){

            public void onCancel() {
            }

            public void onComplete(Object arg) {
                try {
                    JSONObject jsonObject = new JSONObject(arg.toString());
                    HashMap<String, String> infos = new HashMap<String, String>();
                    infos.put("screen_name", jsonObject.optString("nickname"));
                    infos.put("gender", jsonObject.optString("gender"));
                    infos.put("profile_image_url", jsonObject.optString("figureurl_qq_2"));
                    infos.put("is_yellow_year_vip", jsonObject.optString("is_yellow_year_vip"));
                    infos.put("yellow_vip_level", jsonObject.optString("yellow_vip_level"));
                    infos.put("msg", jsonObject.optString("msg"));
                    infos.put("city", jsonObject.optString("city"));
                    infos.put("vip", jsonObject.optString("vip"));
                    infos.put("level", jsonObject.optString("level"));
                    infos.put("province", jsonObject.optString("province"));
                    infos.put("is_yellow_vip", jsonObject.optString("is_yellow_vip"));
                    infos.put("openid", UMQQSsoHandler.this.qqPreferences.getuid());
                    listener.onComplete(SHARE_MEDIA.QQ, 2, infos);
                }
                catch (JSONException e) {
                    listener.onComplete(SHARE_MEDIA.QQ, 2, null);
                }
            }

            public void onError(UiError arg0) {
                listener.onError(SHARE_MEDIA.QQ, 2, new Throwable(arg0.toString()));
            }
        });
    }
}

