/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.http.util.EncodingUtils;
import org.xmlpull.v1.XmlPullParser;

public class ResourceManager {
    private static final String TAG = ResourceManager.class.getName();
    private static final String DRAWABLE = "drawable";
    private static final String DRAWABLE_LDPI = "drawable-ldpi";
    private static final String DRAWABLE_MDPI = "drawable-mdpi";
    private static final String DRAWABLE_HDPI = "drawable-hdpi";
    private static final String DRAWABLE_XHDPI = "drawable-xhdpi";
    private static final String DRAWABLE_XXHDPI = "drawable-xxhdpi";
    private static final String[] PRE_INSTALL_DRAWBLE_PATHS = new String[]{"drawable-xxhdpi", "drawable-xhdpi", "drawable-hdpi", "drawable-mdpi", "drawable-ldpi", "drawable"};

    public static String getString(Context context, String en, String cn, String tw) {
        Locale locale = ResourceManager.getLanguage();
        if (Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            return cn;
        }
        if (Locale.TRADITIONAL_CHINESE.equals(locale)) {
            return tw;
        }
        return en;
    }

    public static Drawable getDrawable(Context context, String fileName) {
        String path = ResourceManager.getAppropriatePathOfDrawable(context, fileName);
        return ResourceManager.getDrawableFromAssert(context, path, false);
    }

    public static Drawable getNinePatchDrawable(Context context, String fileName) {
        String path = ResourceManager.getAppropriatePathOfDrawable(context, fileName);
        return ResourceManager.getDrawableFromAssert(context, path, true);
    }

    public static Locale getLanguage() {
        Locale locale = Locale.getDefault();
        if (Locale.SIMPLIFIED_CHINESE.equals(locale) || Locale.TRADITIONAL_CHINESE.equals(locale)) {
            return locale;
        }
        return Locale.ENGLISH;
    }

    private static String getAppropriatePathOfDrawable(Context context, String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            LogUtil.e(TAG, "id is NOT correct!");
            return null;
        }
        String currentDpi = ResourceManager.getCurrentDpiFolder(context);
        LogUtil.d(TAG, "find Appropriate path...");
        int existIndexLeftDpi = -1;
        int currentDpiIndex = -1;
        int existIndexRightDpi = -1;
        int index = 0;
        while (index < PRE_INSTALL_DRAWBLE_PATHS.length) {
            String resPath;
            if (PRE_INSTALL_DRAWBLE_PATHS[index].equals(currentDpi)) {
                currentDpiIndex = index;
            }
            if (ResourceManager.isFileExisted(context, resPath = String.valueOf(PRE_INSTALL_DRAWBLE_PATHS[index]) + "/" + fileName)) {
                if (currentDpiIndex == index) {
                    return resPath;
                }
                if (currentDpiIndex < 0) {
                    existIndexLeftDpi = index;
                } else {
                    existIndexRightDpi = index;
                    break;
                }
            }
            ++index;
        }
        int properDpi = -1;
        if (existIndexLeftDpi > 0 && existIndexRightDpi > 0) {
            properDpi = Math.abs(currentDpiIndex - existIndexRightDpi) <= Math.abs(currentDpiIndex - existIndexLeftDpi) ? existIndexRightDpi : existIndexLeftDpi;
        } else if (existIndexLeftDpi > 0 && existIndexRightDpi < 0) {
            properDpi = existIndexLeftDpi;
        } else if (existIndexLeftDpi < 0 && existIndexRightDpi > 0) {
            properDpi = existIndexRightDpi;
        } else {
            properDpi = -1;
            LogUtil.e(TAG, "Not find the appropriate path for drawable");
        }
        if (properDpi < 0) {
            LogUtil.e(TAG, "Not find the appropriate path for drawable");
            return null;
        }
        return String.valueOf(PRE_INSTALL_DRAWBLE_PATHS[properDpi]) + "/" + fileName;
    }

    private static Drawable getDrawableFromAssert(Context context, String relativePath, boolean isNinePatch) {
        BitmapDrawable rtDrawable;
        block13: {
            rtDrawable = null;
            AssetManager asseets = context.getAssets();
            InputStream is = null;
            try {
                try {
                    is = asseets.open(relativePath);
                    if (is == null) break block13;
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
                    DisplayMetrics metrics = context.getResources().getDisplayMetrics();
                    if (isNinePatch) {
                        Configuration config = context.getResources().getConfiguration();
                        Resources res = new Resources(context.getAssets(), metrics, config);
                        rtDrawable = new NinePatchDrawable(res, bitmap, bitmap.getNinePatchChunk(), new Rect(0, 0, 0, 0), null);
                        break block13;
                    }
                    bitmap.setDensity(metrics.densityDpi);
                    rtDrawable = new BitmapDrawable(context.getResources(), bitmap);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (is == null) break block13;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    is = null;
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    is = null;
                }
            }
        }
        return rtDrawable;
    }

    private static boolean isFileExisted(Context context, String filePath) {
        if (context == null || TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        AssetManager asseets = context.getAssets();
        InputStream is = null;
        try {
            is = asseets.open(filePath);
            LogUtil.d(TAG, "file [" + filePath + "] existed");
            return true;
        }
        catch (IOException e) {
            LogUtil.d(TAG, "file [" + filePath + "] NOT existed");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                is = null;
            }
        }
        return false;
    }

    private static String getCurrentDpiFolder(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        int density = dm.densityDpi;
        if (density <= 120) {
            return DRAWABLE_LDPI;
        }
        if (density > 120 && density <= 160) {
            return DRAWABLE_MDPI;
        }
        if (density > 160 && density <= 240) {
            return DRAWABLE_HDPI;
        }
        if (density > 240 && density <= 320) {
            return DRAWABLE_XHDPI;
        }
        return DRAWABLE_XXHDPI;
    }

    private static View extractView(Context context, String fileName, ViewGroup root) throws Exception {
        XmlResourceParser parser = context.getAssets().openXmlResourceParser(fileName);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        return inflater.inflate((XmlPullParser)parser, root);
    }

    private static Drawable extractDrawable(Context context, String fileName) throws Exception {
        InputStream inputStream = context.getAssets().open(fileName);
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        TypedValue value = new TypedValue();
        value.density = dm.densityDpi;
        Drawable drawable = Drawable.createFromResourceStream((Resources)context.getResources(), (TypedValue)value, (InputStream)inputStream, (String)fileName);
        inputStream.close();
        return drawable;
    }

    public static int dp2px(Context context, int dp) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        int px = (int)((double)((float)dp * dm.density) + 0.5);
        return px;
    }

    public static ColorStateList createColorStateList(int normal, int pressed) {
        int[] colors = new int[]{pressed, pressed, pressed, normal};
        int[][] states = new int[][]{{16842919}, {0x10100A1}, {16842908}, StateSet.WILD_CARD};
        return new ColorStateList((int[][])states, colors);
    }

    public static StateListDrawable createStateListDrawable(Context context, String normalPicName, String pressedPicName) {
        Drawable normalDrawable = null;
        normalDrawable = normalPicName.indexOf(".9") > -1 ? ResourceManager.getNinePatchDrawable(context, normalPicName) : ResourceManager.getDrawable(context, normalPicName);
        Drawable pressedDrawable = null;
        pressedDrawable = pressedPicName.indexOf(".9") > -1 ? ResourceManager.getNinePatchDrawable(context, pressedPicName) : ResourceManager.getDrawable(context, pressedPicName);
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16842919}, pressedDrawable);
        drawable.addState(new int[]{0x10100A1}, pressedDrawable);
        drawable.addState(new int[]{16842908}, pressedDrawable);
        drawable.addState(StateSet.WILD_CARD, normalDrawable);
        return drawable;
    }

    public static StateListDrawable createStateListDrawable(Context context, String normalPicName, String pressedPicName, String enabledPicName) {
        Drawable normalDrawable = null;
        normalDrawable = normalPicName.indexOf(".9") > -1 ? ResourceManager.getNinePatchDrawable(context, normalPicName) : ResourceManager.getDrawable(context, normalPicName);
        Drawable enableDrawable = null;
        enableDrawable = enabledPicName.indexOf(".9") > -1 ? ResourceManager.getNinePatchDrawable(context, enabledPicName) : ResourceManager.getDrawable(context, enabledPicName);
        Drawable pressedDrawable = null;
        pressedDrawable = pressedPicName.indexOf(".9") > -1 ? ResourceManager.getNinePatchDrawable(context, pressedPicName) : ResourceManager.getDrawable(context, pressedPicName);
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16842919}, pressedDrawable);
        drawable.addState(new int[]{0x10100A1}, pressedDrawable);
        drawable.addState(new int[]{16842908}, pressedDrawable);
        drawable.addState(new int[]{0x101000E}, enableDrawable);
        drawable.addState(StateSet.WILD_CARD, normalDrawable);
        return drawable;
    }

    public static String readCountryFromAsset(Context context, String assetName) {
        String content = "";
        try {
            InputStream is = context.getAssets().open(assetName);
            if (is != null) {
                DataInputStream dIs = new DataInputStream(is);
                int length = dIs.available();
                byte[] buffer = new byte[length];
                dIs.read(buffer);
                content = EncodingUtils.getString((byte[])buffer, (String)"UTF-8");
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }
}

