/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.sina.weibo.sdk.utils.BitmapHelper;
import com.sina.weibo.sdk.utils.NetworkHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtils {
    private static void revitionImageSizeHD(String picfile, int size, int quality) throws IOException {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be greater than 0!");
        }
        if (!ImageUtils.isFileExisted(picfile)) {
            throw new FileNotFoundException(picfile == null ? "null" : picfile);
        }
        if (!BitmapHelper.verifyBitmap(picfile)) {
            throw new IOException("");
        }
        int photoSizesOrg = 2 * size;
        FileInputStream input = new FileInputStream(picfile);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opts);
        try {
            input.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int rate = 0;
        int i = 0;
        while (true) {
            if (opts.outWidth >> i <= photoSizesOrg && opts.outHeight >> i <= photoSizesOrg) break;
            ++i;
        }
        rate = i;
        opts.inSampleSize = (int)Math.pow(2.0, rate);
        opts.inJustDecodeBounds = false;
        Bitmap temp = ImageUtils.safeDecodeBimtapFile(picfile, opts);
        if (temp == null) {
            throw new IOException("Bitmap decode error!");
        }
        ImageUtils.deleteDependon(picfile);
        ImageUtils.makesureFileExist(picfile);
        int org = temp.getWidth() > temp.getHeight() ? temp.getWidth() : temp.getHeight();
        float rateOutPut = (float)size / (float)org;
        if (rateOutPut < 1.0f) {
            Bitmap outputBitmap;
            while (true) {
                try {
                    outputBitmap = Bitmap.createBitmap((int)((int)((float)temp.getWidth() * rateOutPut)), (int)((int)((float)temp.getHeight() * rateOutPut)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                catch (OutOfMemoryError e) {
                    System.gc();
                    rateOutPut = (float)((double)rateOutPut * 0.8);
                    continue;
                }
                break;
            }
            if (outputBitmap == null) {
                temp.recycle();
            }
            Canvas canvas = new Canvas(outputBitmap);
            Matrix matrix = new Matrix();
            matrix.setScale(rateOutPut, rateOutPut);
            canvas.drawBitmap(temp, matrix, new Paint());
            temp.recycle();
            temp = outputBitmap;
        }
        FileOutputStream output = new FileOutputStream(picfile);
        if (opts != null && opts.outMimeType != null && opts.outMimeType.contains("png")) {
            temp.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)output);
        } else {
            temp.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)output);
        }
        try {
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        temp.recycle();
    }

    private static void revitionImageSize(String picfile, int size, int quality) throws IOException {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be greater than 0!");
        }
        if (!ImageUtils.isFileExisted(picfile)) {
            throw new FileNotFoundException(picfile == null ? "null" : picfile);
        }
        if (!BitmapHelper.verifyBitmap(picfile)) {
            throw new IOException("");
        }
        FileInputStream input = new FileInputStream(picfile);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opts);
        try {
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int rate = 0;
        int i = 0;
        while (true) {
            if (opts.outWidth >> i <= size && opts.outHeight >> i <= size) break;
            ++i;
        }
        rate = i;
        opts.inSampleSize = (int)Math.pow(2.0, rate);
        opts.inJustDecodeBounds = false;
        Bitmap temp = ImageUtils.safeDecodeBimtapFile(picfile, opts);
        if (temp == null) {
            throw new IOException("Bitmap decode error!");
        }
        ImageUtils.deleteDependon(picfile);
        ImageUtils.makesureFileExist(picfile);
        FileOutputStream output = new FileOutputStream(picfile);
        if (opts != null && opts.outMimeType != null && opts.outMimeType.contains("png")) {
            temp.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)output);
        } else {
            temp.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)output);
        }
        try {
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        temp.recycle();
    }

    public static boolean revitionPostImageSize(Context context, String picfile) {
        try {
            if (NetworkHelper.isWifiValid(context)) {
                ImageUtils.revitionImageSizeHD(picfile, 1600, 75);
            } else {
                ImageUtils.revitionImageSize(picfile, 1024, 75);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Bitmap safeDecodeBimtapFile(String bmpFile, BitmapFactory.Options opts) {
        BitmapFactory.Options optsTmp = opts;
        if (optsTmp == null) {
            optsTmp = new BitmapFactory.Options();
            optsTmp.inSampleSize = 1;
        }
        Bitmap bmp = null;
        FileInputStream input = null;
        int MAX_TRIAL = 5;
        int i = 0;
        while (i < 5) {
            try {
                input = new FileInputStream(bmpFile);
                bmp = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opts);
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                optsTmp.inSampleSize *= 2;
                try {
                    input.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                break;
            }
            ++i;
        }
        return bmp;
    }

    private static void delete(File file) {
        if (file != null && file.exists() && !file.delete()) {
            throw new RuntimeException(String.valueOf(file.getAbsolutePath()) + " doesn't be deleted!");
        }
    }

    private static boolean deleteDependon(String filepath) {
        if (TextUtils.isEmpty((CharSequence)filepath)) {
            return false;
        }
        File file = new File(filepath);
        int retryCount = 1;
        int maxRetryCount = 0;
        maxRetryCount = maxRetryCount < 1 ? 5 : maxRetryCount;
        boolean isDeleted = false;
        if (file != null) {
            while (!isDeleted && retryCount <= maxRetryCount && file.isFile() && file.exists()) {
                isDeleted = file.delete();
                if (isDeleted) continue;
                ++retryCount;
            }
        }
        return isDeleted;
    }

    private static boolean isFileExisted(String filepath) {
        if (TextUtils.isEmpty((CharSequence)filepath)) {
            return false;
        }
        File file = new File(filepath);
        return file != null && file.exists();
    }

    private static boolean isParentExist(File file) {
        if (file == null) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            return file.exists() || file.mkdirs();
        }
        return false;
    }

    private static void makesureFileExist(String filePath) {
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (file != null && !file.exists() && ImageUtils.isParentExist(file)) {
            if (file.exists()) {
                ImageUtils.delete(file);
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isWifi(Context mContext) {
        ConnectivityManager connectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }
}

