/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.register.mobile;

import android.content.Context;
import android.text.TextUtils;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PinyinUtils {
    private static PinyinUtils sInstance;
    private static short[] sPinyinIndex;
    private static final String[] PINYIN;
    private static volatile boolean isLoad;
    private static final char SPECIAL_HANZI = '\u3007';
    private static final String SPECIAL_HANZI_PINYIN = "LING";
    private static final char FIRST_CHINA = '\u4e00';
    private static final char LAST_CHINA = '\u9fa5';
    private static final int DISTINGUISH_LEN = 10;

    static {
        PINYIN = new String[]{"a", "ai", "an", "ang", "ao", "ba", "bai", "ban", "bang", "bao", "bei", "ben", "beng", "bi", "bian", "biao", "bie", "bin", "bing", "bo", "bu", "ca", "cai", "can", "cang", "cao", "ce", "cen", "ceng", "cha", "chai", "chan", "chang", "chao", "che", "chen", "cheng", "chi", "chong", "chou", "chu", "chuai", "chuan", "chuang", "chui", "chun", "chuo", "ci", "cong", "cou", "cu", "cuan", "cui", "cun", "cuo", "da", "dai", "dan", "dang", "dao", "de", "deng", "di", "dia", "dian", "diao", "die", "ding", "diu", "dong", "dou", "du", "duan", "dui", "dun", "duo", "e", "ei", "en", "er", "fa", "fan", "fang", "fei", "fen", "feng", "fo", "fou", "fu", "ga", "gai", "gan", "gang", "gao", "ge", "gei", "gen", "geng", "gong", "gou", "gu", "gua", "guai", "guan", "guang", "gui", "gun", "guo", "ha", "hai", "han", "hang", "hao", "he", "hei", "hen", "heng", "hong", "hou", "hu", "hua", "huai", "huan", "huang", "hui", "hun", "huo", "ji", "jia", "jian", "jiang", "jiao", "jie", "jin", "jing", "jiong", "jiu", "ju", "juan", "jue", "jun", "ka", "kai", "kan", "kang", "kao", "ke", "ken", "keng", "kong", "kou", "ku", "kua", "kuai", "kuan", "kuang", "kui", "kun", "kuo", "la", "lai", "lan", "lang", "lao", "le", "lei", "leng", "li", "lia", "lian", "liang", "liao", "lie", "lin", "ling", "liu", "long", "lou", "lu", "luan", "lun", "luo", "lv", "lve", "m", "ma", "mai", "man", "mang", "mao", "me", "mei", "men", "meng", "mi", "mian", "miao", "mie", "min", "ming", "miu", "mo", "mou", "mu", "na", "nai", "nan", "nang", "nao", "ne", "nei", "nen", "neng", "ng", "ni", "nian", "niang", "niao", "nie", "nin", "ning", "niu", "none", "nong", "nou", "nu", "nuan", "nuo", "nv", "nve", "o", "ou", "pa", "pai", "pan", "pang", "pao", "pei", "pen", "peng", "pi", "pian", "piao", "pie", "pin", "ping", "po", "pou", "pu", "qi", "qia", "qian", "qiang", "qiao", "qie", "qin", "qing", "qiong", "qiu", "qu", "quan", "que", "qun", "ran", "rang", "rao", "re", "ren", "reng", "ri", "rong", "rou", "ru", "ruan", "rui", "run", "ruo", "sa", "sai", "san", "sang", "sao", "se", "sen", "seng", "sha", "shai", "shan", "shang", "shao", "she", "shei", "shen", "sheng", "shi", "shou", "shu", "shua", "shuai", "shuan", "shuang", "shui", "shun", "shuo", "si", "song", "sou", "su", "suan", "sui", "sun", "suo", "ta", "tai", "tan", "tang", "tao", "te", "teng", "ti", "tian", "tiao", "tie", "ting", "tong", "tou", "tu", "tuan", "tui", "tun", "tuo", "wa", "wai", "wan", "wang", "wei", "wen", "weng", "wo", "wu", "xi", "xia", "xian", "xiang", "xiao", "xie", "xin", "xing", "xiong", "xiu", "xu", "xuan", "xue", "xun", "ya", "yan", "yang", "yao", "ye", "yi", "yiao", "yin", "ying", "yo", "yong", "you", "yu", "yuan", "yue", "yun", "za", "zai", "zan", "zang", "zao", "ze", "zei", "zen", "zeng", "zha", "zhai", "zhan", "zhang", "zhao", "zhe", "zhei", "zhen", "zheng", "zhi", "zhong", "zhou", "zhu", "zhua", "zhuai", "zhuan", "zhuang", "zhui", "zhun", "zhuo", "zi", "zong", "zou", "zu", "zuan", "zui", "zun", "zuo"};
        isLoad = false;
    }

    private PinyinUtils() {
    }

    public static synchronized PinyinUtils getInstance(Context ctx) {
        if (sInstance == null) {
            sInstance = new PinyinUtils();
        }
        PinyinUtils.loadData(ctx);
        return sInstance;
    }

    private static void loadData(Context ctx) {
        InputStream input = null;
        FilterInputStream dataInput = null;
        try {
            if (isLoad) {
                return;
            }
            try {
                input = ctx.getAssets().open("pinyinindex");
                dataInput = new DataInputStream(input);
                long length = dataInput.available() >> 1;
                sPinyinIndex = new short[(int)length];
                int i = 0;
                while (i < sPinyinIndex.length) {
                    PinyinUtils.sPinyinIndex[i] = ((DataInputStream)dataInput).readShort();
                    ++i;
                }
                isLoad = true;
            }
            catch (IOException e) {
                isLoad = false;
            }
            catch (Exception e) {
                isLoad = false;
            }
        }
        finally {
            try {
                if (dataInput != null) {
                    dataInput.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getPinyin(char ch) {
        if (!isLoad) {
            return "";
        }
        String pinyin = "";
        if (ch == '\u3007') {
            return SPECIAL_HANZI_PINYIN;
        }
        if (ch < '\u4e00' || ch > '\u9fa5') {
            return String.valueOf(ch);
        }
        int pos = ch - 19968;
        pinyin = PINYIN[sPinyinIndex[pos]];
        if (pinyin == null) {
            pinyin = "";
        }
        return pinyin;
    }

    public String getPinyin(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        if (!isLoad) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            sb.append(this.getPinyin(c));
            ++i;
        }
        return sb.toString();
    }

    public MatchedResult getMatchedResult(String src, String input) {
        int index;
        MatchedResult result = new MatchedResult();
        result.start = -1;
        result.end = -1;
        if (!isLoad) {
            return result;
        }
        if (TextUtils.isEmpty((CharSequence)src) || TextUtils.isEmpty((CharSequence)input)) {
            return result;
        }
        src = src.toUpperCase();
        input = input.toUpperCase();
        int n = Math.min(src.length(), input.length());
        if (n > 10) {
            src = src.substring(0, 10);
            input = input.substring(0, 10);
        }
        if ((index = src.indexOf(input)) >= 0) {
            result.start = index;
            result.end = index + input.length() - 1;
        }
        char[] search = new char[input.length()];
        int i = 0;
        while (i < input.length()) {
            search[i] = input.charAt(i);
            ++i;
        }
        char[] org = new char[src.length()];
        String[] fullPinyin = new String[src.length()];
        int srcLen = src.length();
        int i2 = 0;
        while (i2 < srcLen) {
            char ch;
            org[i2] = ch = src.charAt(i2);
            String pinyinCache = this.getPinyin(ch);
            fullPinyin[i2] = !TextUtils.isEmpty((CharSequence)pinyinCache) ? pinyinCache.toUpperCase() : String.valueOf(ch);
            ++i2;
        }
        char firstSearch = search[0];
        int i3 = 0;
        while (i3 < fullPinyin.length) {
            char ch1 = fullPinyin[i3].charAt(0);
            char ch2 = org[i3];
            int pos = -1;
            if ((ch1 == firstSearch || ch2 == firstSearch) && (pos = this.distinguish(search, 0, this.subCharRangeArray(org, i3, org.length - 1), this.subStringRangeArray(fullPinyin, i3, fullPinyin.length - 1), 0, 0)) != -1) {
                result.start = i3;
                result.end = i3 + pos;
                return result;
            }
            ++i3;
        }
        return result;
    }

    public int distinguish(char[] search, int searchIndex, char[] src, String[] pinyin, int wordIndex, int wordStart) {
        if (searchIndex == 0 && (search[0] == src[0] || search[0] == pinyin[0].charAt(0))) {
            if (search.length != 1) {
                return this.distinguish(search, 1, src, pinyin, 0, 1);
            }
            return 0;
        }
        if (pinyin[wordIndex].length() > wordStart && searchIndex < search.length && (search[searchIndex] == src[wordIndex] || search[searchIndex] == pinyin[wordIndex].charAt(wordStart))) {
            if (searchIndex == search.length - 1) {
                if (this.distinguish(search, src, pinyin, wordIndex)) {
                    return wordIndex;
                }
                return -1;
            }
            return this.distinguish(search, searchIndex + 1, src, pinyin, wordIndex, wordStart + 1);
        }
        if (pinyin.length > wordIndex + 1 && searchIndex < search.length && (search[searchIndex] == src[wordIndex + 1] || search[searchIndex] == pinyin[wordIndex + 1].charAt(0))) {
            if (searchIndex == search.length - 1) {
                if (this.distinguish(search, src, pinyin, wordIndex)) {
                    return wordIndex + 1;
                }
                return -1;
            }
            return this.distinguish(search, searchIndex + 1, src, pinyin, wordIndex + 1, 1);
        }
        if (pinyin.length > wordIndex + 1) {
            int i = 1;
            while (i < searchIndex) {
                if (this.distinguish(search, searchIndex - i, src, pinyin, wordIndex + 1, 0) != -1) {
                    return wordIndex + 1;
                }
                ++i;
            }
        }
        return -1;
    }

    private boolean distinguish(char[] search, char[] src, String[] pinyin, int wordIndex) {
        String searchString = new String(search);
        int lastIndex = 0;
        int i = 0;
        i = 0;
        while (i < wordIndex) {
            lastIndex = searchString.indexOf(pinyin[i].charAt(0), lastIndex);
            if (lastIndex == -1) {
                lastIndex = searchString.indexOf(src[i], lastIndex);
            }
            if (lastIndex == -1) {
                return false;
            }
            ++lastIndex;
            ++i;
        }
        return true;
    }

    private char[] subCharRangeArray(char[] org, int start, int end) {
        int len = end - start + 1;
        char[] ret = new char[len];
        int i = start;
        int j = 0;
        while (i <= end) {
            ret[j] = org[i];
            ++i;
            ++j;
        }
        return ret;
    }

    private String[] subStringRangeArray(String[] org, int start, int end) {
        int len = end - start + 1;
        String[] ret = new String[len];
        int i = start;
        int j = 0;
        while (i <= end) {
            ret[j] = org[i];
            ++i;
            ++j;
        }
        return ret;
    }

    public static PinyinUtils getObject() {
        return sInstance;
    }

    public static class MatchedResult {
        public int start = -1;
        public int end = -1;
    }
}

