/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.cmd;

import android.content.Context;
import android.content.SharedPreferences;
import com.sina.weibo.sdk.cmd.AppInstallCmd;
import com.sina.weibo.sdk.cmd.AppInstallCmdExecutor;
import com.sina.weibo.sdk.cmd.AppInvokeCmd;
import com.sina.weibo.sdk.cmd.AppInvokeCmdExecutor;
import com.sina.weibo.sdk.cmd.CmdInfo;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.NetUtils;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.AesEncrypt;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.Utility;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class WbAppActivator {
    private static final String TAG = WbAppActivator.class.getName();
    private Context mContext;
    private static WbAppActivator mInstance;
    private String mAppkey;
    private volatile ReentrantLock mLock = new ReentrantLock(true);
    private AppInvokeCmdExecutor mInvokeExecutor;
    private AppInstallCmdExecutor mInstallExecutor;

    private WbAppActivator(Context ctx, String appkey) {
        this.mContext = ctx.getApplicationContext();
        this.mInvokeExecutor = new AppInvokeCmdExecutor(this.mContext);
        this.mInstallExecutor = new AppInstallCmdExecutor(this.mContext);
        this.mAppkey = appkey;
    }

    public static synchronized WbAppActivator getInstance(Context ctx, String appkey) {
        if (mInstance == null) {
            mInstance = new WbAppActivator(ctx, appkey);
        }
        return mInstance;
    }

    public void activateApp() {
        final SharedPreferences sdkSp = FrequencyHelper.getWeiboSdkSp(this.mContext);
        long frequency = FrequencyHelper.getFrequency(this.mContext, sdkSp);
        long lastTime = FrequencyHelper.getLastTime(this.mContext, sdkSp);
        long period = System.currentTimeMillis() - lastTime;
        if (period < frequency) {
            LogUtil.v(TAG, String.format("it's only %d ms from last time get cmd", period));
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogUtil.v(TAG, "mLock.isLocked()--->" + WbAppActivator.this.mLock.isLocked());
                if (!WbAppActivator.this.mLock.tryLock()) {
                    return;
                }
                CmdInfo cmds = null;
                try {
                    try {
                        String result = WbAppActivator.requestCmdInfo(WbAppActivator.this.mContext, WbAppActivator.this.mAppkey);
                        if (result != null) {
                            String decryptStr = AesEncrypt.Decrypt(result);
                            cmds = new CmdInfo(decryptStr);
                            WbAppActivator.this.handleInstallCmd(cmds.getInstallCmds());
                            WbAppActivator.this.handleInvokeCmd(cmds.getInvokeCmds());
                        }
                    }
                    catch (WeiboException e) {
                        LogUtil.e(TAG, e.getMessage());
                        WbAppActivator.this.mLock.unlock();
                        if (cmds != null) {
                            FrequencyHelper.saveFrequency(WbAppActivator.this.mContext, sdkSp, cmds.getFrequency());
                            FrequencyHelper.saveLastTime(WbAppActivator.this.mContext, sdkSp, System.currentTimeMillis());
                        }
                        LogUtil.v(TAG, "after unlock \n mLock.isLocked()--->" + WbAppActivator.this.mLock.isLocked());
                    }
                }
                finally {
                    WbAppActivator.this.mLock.unlock();
                    if (cmds != null) {
                        FrequencyHelper.saveFrequency(WbAppActivator.this.mContext, sdkSp, cmds.getFrequency());
                        FrequencyHelper.saveLastTime(WbAppActivator.this.mContext, sdkSp, System.currentTimeMillis());
                    }
                    LogUtil.v(TAG, "after unlock \n mLock.isLocked()--->" + WbAppActivator.this.mLock.isLocked());
                }
            }
        }).start();
    }

    private static String requestCmdInfo(Context ctx, String appkey) {
        String url = "http://api.weibo.cn/2/client/common_config";
        String pkgName = ctx.getPackageName();
        String keyHash = Utility.getSign(ctx, pkgName);
        WeiboParameters params = new WeiboParameters(appkey);
        params.put("appkey", appkey);
        params.put("packagename", pkgName);
        params.put("key_hash", keyHash);
        params.put("version", "0031205000");
        return NetUtils.internalHttpRequest(ctx, "http://api.weibo.cn/2/client/common_config", "GET", params);
    }

    private void handleInstallCmd(List<AppInstallCmd> installCmds) {
        if (installCmds != null) {
            this.mInstallExecutor.start();
            for (AppInstallCmd installCmd : installCmds) {
                this.mInstallExecutor.doExecutor(installCmd);
            }
            this.mInstallExecutor.stop();
        }
    }

    private void handleInvokeCmd(List<AppInvokeCmd> invokeCmds) {
        if (invokeCmds != null) {
            for (AppInvokeCmd invokeCmd : invokeCmds) {
                this.mInvokeExecutor.doExecutor(invokeCmd);
            }
        }
    }

    private static class FrequencyHelper {
        private static final String WEIBO_SDK_PREFERENCES_NAME = "com_sina_weibo_sdk";
        private static final int DEFAULT_FREQUENCY = 3600000;
        private static final String KEY_FREQUENCY = "frequency_get_cmd";
        private static final String KEY_LAST_TIME_GET_CMD = "last_time_get_cmd";

        private FrequencyHelper() {
        }

        public static SharedPreferences getWeiboSdkSp(Context ctx) {
            SharedPreferences pref = ctx.getSharedPreferences(WEIBO_SDK_PREFERENCES_NAME, 0);
            return pref;
        }

        public static long getFrequency(Context ctx, SharedPreferences sp) {
            if (sp != null) {
                return sp.getLong(KEY_FREQUENCY, 3600000L);
            }
            return 3600000L;
        }

        public static void saveFrequency(Context ctx, SharedPreferences sp, long frequency) {
            if (sp != null && frequency > 0L) {
                SharedPreferences.Editor editor = sp.edit();
                editor.putLong(KEY_FREQUENCY, frequency);
                editor.commit();
            }
        }

        public static long getLastTime(Context ctx, SharedPreferences sp) {
            if (sp != null) {
                return sp.getLong(KEY_LAST_TIME_GET_CMD, 0L);
            }
            return 0L;
        }

        public static void saveLastTime(Context ctx, SharedPreferences sp, long lastTime) {
            if (sp != null) {
                SharedPreferences.Editor editor = sp.edit();
                editor.putLong(KEY_LAST_TIME_GET_CMD, lastTime);
                editor.commit();
            }
        }
    }
}

