/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.sina.weibo.sdk.ApiUtils;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class WeiboAppManager {
    private static final String TAG = WeiboAppManager.class.getName();
    private static final Uri WEIBO_NAME_URI = Uri.parse((String)"content://com.sina.weibo.sdkProvider/query/package");
    private static final String WEIBO_IDENTITY_ACTION = "com.sina.weibo.action.sdkidentity";
    private static final String SDK_INT_FILE_NAME = "weibo_for_sdk.json";
    private static WeiboAppManager sInstance;
    private Context mContext;

    private WeiboAppManager(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public static synchronized WeiboAppManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new WeiboAppManager(context);
        }
        return sInstance;
    }

    public synchronized WeiboInfo getWeiboInfo() {
        return this.queryWeiboInfoInternal(this.mContext);
    }

    private WeiboInfo queryWeiboInfoInternal(Context context) {
        boolean hasWinfo2;
        WeiboInfo winfo1 = this.queryWeiboInfoByProvider(context);
        WeiboInfo winfo2 = this.queryWeiboInfoByAsset(context);
        boolean hasWinfo1 = winfo1 != null;
        boolean bl = hasWinfo2 = winfo2 != null;
        if (hasWinfo1 && hasWinfo2) {
            if (winfo1.getSupportApi() >= winfo2.getSupportApi()) {
                return winfo1;
            }
            return winfo2;
        }
        if (hasWinfo1) {
            return winfo1;
        }
        if (hasWinfo2) {
            return winfo2;
        }
        return null;
    }

    private WeiboInfo queryWeiboInfoByProvider(Context context) {
        block11: {
            ContentResolver cr = context.getContentResolver();
            Cursor cursor = null;
            try {
                cursor = cr.query(WEIBO_NAME_URI, null, null, null, null);
                if (cursor == null) {
                    return null;
                }
                int supportApiIndex = cursor.getColumnIndex("support_api");
                int packageIndex = cursor.getColumnIndex("package");
                if (!cursor.moveToFirst()) break block11;
                int supportApiInt = -1;
                String supportApi = cursor.getString(supportApiIndex);
                try {
                    supportApiInt = Integer.parseInt(supportApi);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                String packageName = cursor.getString(packageIndex);
                if (!TextUtils.isEmpty((CharSequence)packageName) && ApiUtils.validateWeiboSign(context, packageName)) {
                    WeiboInfo winfo = new WeiboInfo();
                    winfo.setPackageName(packageName);
                    winfo.setSupportApi(supportApiInt);
                    WeiboInfo weiboInfo = winfo;
                    return weiboInfo;
                }
            }
            catch (Exception e) {
                LogUtil.e(TAG, e.getMessage());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                    cursor = null;
                }
            }
        }
        return null;
    }

    private WeiboInfo queryWeiboInfoByAsset(Context context) {
        Intent intent = new Intent(WEIBO_IDENTITY_ACTION);
        intent.addCategory("android.intent.category.DEFAULT");
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        if (list == null || list.isEmpty()) {
            return null;
        }
        WeiboInfo weiboInfo = null;
        for (ResolveInfo ri : list) {
            String packageName;
            WeiboInfo tmpWeiboInfo;
            if (ri.serviceInfo == null || ri.serviceInfo.applicationInfo == null || TextUtils.isEmpty((CharSequence)ri.serviceInfo.applicationInfo.packageName) || (tmpWeiboInfo = this.parseWeiboInfoByAsset(packageName = ri.serviceInfo.applicationInfo.packageName)) == null) continue;
            if (weiboInfo == null) {
                weiboInfo = tmpWeiboInfo;
                continue;
            }
            if (weiboInfo.getSupportApi() >= tmpWeiboInfo.getSupportApi()) continue;
            weiboInfo = tmpWeiboInfo;
        }
        return weiboInfo;
    }

    public WeiboInfo parseWeiboInfoByAsset(String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        InputStream is = null;
        try {
            int readNum;
            Context weiboContext = this.mContext.createPackageContext(packageName, 2);
            int bufferSize = 4096;
            byte[] buf = new byte[4096];
            is = weiboContext.getAssets().open(SDK_INT_FILE_NAME);
            StringBuilder sbContent = new StringBuilder();
            while ((readNum = is.read(buf, 0, 4096)) != -1) {
                sbContent.append(new String(buf, 0, readNum));
            }
            if (TextUtils.isEmpty((CharSequence)sbContent.toString()) || !ApiUtils.validateWeiboSign(this.mContext, packageName)) {
                return null;
            }
            JSONObject json = new JSONObject(sbContent.toString());
            int supportApi = json.optInt("support_api", -1);
            WeiboInfo winfo = new WeiboInfo();
            winfo.setPackageName(packageName);
            winfo.setSupportApi(supportApi);
            WeiboInfo weiboInfo = winfo;
            return weiboInfo;
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtil.e(TAG, e.getMessage());
        }
        catch (IOException e) {
            LogUtil.e(TAG, e.getMessage());
        }
        catch (JSONException e) {
            LogUtil.e(TAG, e.getMessage());
        }
        catch (Exception e) {
            LogUtil.e(TAG, e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LogUtil.e(TAG, e.getMessage());
                }
            }
        }
        return null;
    }

    public static class WeiboInfo {
        private String mPackageName;
        private int mSupportApi;

        private void setPackageName(String packageName) {
            this.mPackageName = packageName;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        private void setSupportApi(int supportApi) {
            this.mSupportApi = supportApi;
        }

        public int getSupportApi() {
            return this.mSupportApi;
        }

        public boolean isLegal() {
            return !TextUtils.isEmpty((CharSequence)this.mPackageName) && this.mSupportApi > 0;
        }

        public String toString() {
            return "WeiboInfo: PackageName = " + this.mPackageName + ", supportApi = " + this.mSupportApi;
        }
    }
}

