/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.exception.WeiboHttpException;
import com.sina.weibo.sdk.net.CustomRedirectHandler;
import com.sina.weibo.sdk.net.NetStateManager;
import com.sina.weibo.sdk.net.SSLSocketFactoryEx;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.NetworkHelper;
import com.sina.weibo.sdk.utils.Utility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;

public class HttpManager {
    private static final String TAG = "HttpManager";
    private static final String BOUNDARY;
    private static final String MP_BOUNDARY;
    private static final String END_MP_BOUNDARY;
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_GET = "GET";
    private static final int CONNECTION_TIMEOUT = 25000;
    private static final int SOCKET_TIMEOUT = 20000;
    private static final int BUFFER_SIZE = 8192;
    private static SSLSocketFactory sSSLSocketFactory;

    static {
        System.loadLibrary("weibosdkcore");
        BOUNDARY = HttpManager.getBoundry();
        MP_BOUNDARY = "--" + BOUNDARY;
        END_MP_BOUNDARY = "--" + BOUNDARY + "--";
    }

    public static String openUrl(Context context, String url, String method, WeiboParameters params) throws WeiboException {
        HttpResponse response = HttpManager.requestHttpExecute(context, url, method, params);
        String ans = HttpManager.readRsponse(response);
        LogUtil.d(TAG, "Response : " + ans);
        return ans;
    }

    private static HttpResponse requestHttpExecute(Context context, String url, String method, WeiboParameters params) {
        HttpClient client = null;
        ByteArrayOutputStream baos = null;
        HttpResponse response = null;
        try {
            try {
                client = HttpManager.getNewHttpClient();
                client.getParams().setParameter("http.route.default-proxy", (Object)NetStateManager.getAPN());
                HttpDelete request = null;
                HttpManager.setHttpCommonParam(context, params);
                if (method.equals(HTTP_METHOD_GET)) {
                    url = String.valueOf(url) + "?" + params.encodeUrl();
                    request = new HttpGet(url);
                    LogUtil.d(TAG, "requestHttpExecute GET Url : " + url);
                } else if (method.equals(HTTP_METHOD_POST)) {
                    LogUtil.d(TAG, "requestHttpExecute POST Url : " + url);
                    HttpPost post = new HttpPost(url);
                    request = post;
                    baos = new ByteArrayOutputStream();
                    if (params.hasBinaryData()) {
                        post.setHeader("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                        HttpManager.buildParams(baos, params);
                    } else {
                        Object value = params.get("content-type");
                        if (value != null && value instanceof String) {
                            params.remove("content-type");
                            post.setHeader("Content-Type", (String)value);
                        } else {
                            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                        }
                        String postParam = params.encodeUrl();
                        LogUtil.d(TAG, "requestHttpExecute POST postParam : " + postParam);
                        baos.write(postParam.getBytes("UTF-8"));
                    }
                    post.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
                } else if (method.equals("DELETE")) {
                    request = new HttpDelete(url);
                }
                response = client.execute(request);
                StatusLine status = response.getStatusLine();
                int statusCode = status.getStatusCode();
                if (statusCode != 200) {
                    String result = HttpManager.readRsponse(response);
                    throw new WeiboHttpException(result, statusCode);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new WeiboException(e);
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            HttpManager.shutdownHttpClient(client);
        }
        return response;
    }

    private static void setHttpCommonParam(Context context, WeiboParameters params) {
        String aid = "";
        if (!TextUtils.isEmpty((CharSequence)params.getAppKey()) && !TextUtils.isEmpty((CharSequence)(aid = Utility.getAid(context, params.getAppKey())))) {
            params.put("aid", aid);
        }
        String timestamp = HttpManager.getTimestamp();
        params.put("oauth_timestamp", timestamp);
        String token = "";
        Object accessToken = params.get("access_token");
        Object refreshToken = params.get("refresh_token");
        Object phone = params.get("phone");
        if (accessToken != null && accessToken instanceof String) {
            token = (String)accessToken;
        } else if (refreshToken != null && refreshToken instanceof String) {
            token = (String)refreshToken;
        } else if (phone != null && phone instanceof String) {
            token = (String)phone;
        }
        String oauthSign = HttpManager.getOauthSign(context, aid, token, params.getAppKey(), timestamp);
        params.put("oauth_sign", oauthSign);
    }

    public static void shutdownHttpClient(HttpClient client) {
        if (client != null) {
            try {
                client.getConnectionManager().closeExpiredConnections();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String openUrl4RdirectURL(Context context, String url, String method, WeiboParameters params) throws WeiboException {
        DefaultHttpClient client = null;
        String result = "";
        try {
            client = (DefaultHttpClient)HttpManager.getNewHttpClient();
            client.setRedirectHandler(new RedirectHandler(){

                public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
                    LogUtil.d(HttpManager.TAG, "openUrl4RdirectURL isRedirectRequested method");
                    return false;
                }

                public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
                    LogUtil.d(HttpManager.TAG, "openUrl4RdirectURL getLocationURI method");
                    return null;
                }
            });
            HttpManager.setHttpCommonParam(context, params);
            HttpPost request = null;
            client.getParams().setParameter("http.route.default-proxy", (Object)NetStateManager.getAPN());
            if (method.equals(HTTP_METHOD_GET)) {
                url = String.valueOf(url) + "?" + params.encodeUrl();
                LogUtil.d(TAG, "openUrl4RdirectURL GET url : " + url);
                HttpGet get = new HttpGet(url);
                request = get;
            } else if (method.equals(HTTP_METHOD_POST)) {
                HttpPost post = new HttpPost(url);
                LogUtil.d(TAG, "openUrl4RdirectURL POST url : " + url);
                request = post;
            }
            HttpResponse response = client.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 301 || statusCode == 302) {
                String redirectURL = response.getFirstHeader("Location").getValue();
                LogUtil.d(TAG, "RedirectURL = " + redirectURL);
                String string = redirectURL;
                return string;
            }
            if (statusCode == 200) {
                String string = HttpManager.readRsponse(response);
                return string;
            }
            try {
                result = HttpManager.readRsponse(response);
                throw new WeiboHttpException(result, statusCode);
            }
            catch (IOException e) {
                throw new WeiboException(e);
            }
        }
        finally {
            HttpManager.shutdownHttpClient((HttpClient)client);
        }
    }

    public static String openRedirectUrl4LocationUri(Context context, String url, String method, WeiboParameters params) {
        String string;
        DefaultHttpClient client = null;
        CustomRedirectHandler redirectHandler = null;
        try {
            redirectHandler = new CustomRedirectHandler(){

                @Override
                public boolean shouldRedirectUrl(String url) {
                    return true;
                }

                @Override
                public void onReceivedException() {
                }
            };
            client = (DefaultHttpClient)HttpManager.getNewHttpClient();
            client.setRedirectHandler((RedirectHandler)redirectHandler);
            HttpManager.setHttpCommonParam(context, params);
            HttpPost request = null;
            client.getParams().setParameter("http.route.default-proxy", (Object)NetStateManager.getAPN());
            if (method.equals(HTTP_METHOD_GET)) {
                url = String.valueOf(url) + "?" + params.encodeUrl();
                HttpGet get = new HttpGet(url);
                request = get;
            } else if (method.equals(HTTP_METHOD_POST)) {
                HttpPost post;
                request = post = new HttpPost(url);
            }
            request.setHeader("User-Agent", NetworkHelper.generateUA(context));
            client.execute((HttpUriRequest)request);
            string = redirectHandler.getRedirectUrl();
        }
        catch (IOException e) {
            try {
                throw new WeiboException(e);
            }
            catch (Throwable throwable) {
                HttpManager.shutdownHttpClient(client);
                throw throwable;
            }
        }
        HttpManager.shutdownHttpClient((HttpClient)client);
        return string;
    }

    public static synchronized String downloadFile(Context context, String url, String saveDir, String fileName) throws WeiboException {
        block19: {
            File filePath;
            File savePathDir = new File(saveDir);
            if (!savePathDir.exists()) {
                savePathDir.mkdirs();
            }
            if ((filePath = new File(savePathDir, fileName)).exists()) {
                return filePath.getPath();
            }
            if (!URLUtil.isValidUrl((String)url)) {
                return "";
            }
            HttpClient client = HttpManager.getNewHttpClient();
            long tempFileLength = 0L;
            File tempFile = new File(saveDir, String.valueOf(fileName) + "_temp");
            try {
                if (tempFile.exists()) {
                    tempFileLength = tempFile.length();
                } else {
                    tempFile.createNewFile();
                }
                HttpGet request = new HttpGet(url);
                request.setHeader("RANGE", "bytes=" + tempFileLength + "-");
                HttpResponse response = client.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                long totalLength = 0L;
                long startPosition = 0L;
                if (statusCode == 206) {
                    startPosition = tempFileLength;
                    Header[] rangeHeaders = response.getHeaders("Content-Range");
                    if (rangeHeaders != null && rangeHeaders.length != 0) {
                        String rangValue = rangeHeaders[0].getValue();
                        totalLength = Long.parseLong(rangValue.substring(rangValue.indexOf(47) + 1));
                    }
                } else if (statusCode == 200) {
                    startPosition = 0L;
                    Header lengthHeader = response.getFirstHeader("Content-Length");
                    if (lengthHeader != null) {
                        totalLength = Integer.valueOf(lengthHeader.getValue()).intValue();
                    }
                } else {
                    String result = HttpManager.readRsponse(response);
                    throw new WeiboHttpException(result, statusCode);
                }
                InputStream inputStream = null;
                HttpEntity entity = response.getEntity();
                Header header = response.getFirstHeader("Content-Encoding");
                inputStream = header != null && header.getValue().toLowerCase().indexOf("gzip") > -1 ? new GZIPInputStream(entity.getContent()) : entity.getContent();
                RandomAccessFile content = new RandomAccessFile(tempFile, "rw");
                content.seek(startPosition);
                byte[] sBuffer = new byte[1024];
                int readBytes = 0;
                while ((readBytes = inputStream.read(sBuffer)) != -1) {
                    content.write(sBuffer, 0, readBytes);
                }
                content.close();
                inputStream.close();
                if (totalLength == 0L || tempFile.length() < totalLength) {
                    tempFile.delete();
                    break block19;
                }
                tempFile.renameTo(filePath);
                String string = filePath.getPath();
                return string;
            }
            catch (IOException e) {
                e.printStackTrace();
                tempFile.delete();
            }
            finally {
                if (client != null) {
                    client.getConnectionManager().closeExpiredConnections();
                    client.getConnectionManager().closeIdleConnections(300L, TimeUnit.SECONDS);
                }
            }
        }
        return "";
    }

    public static HttpClient getNewHttpClient() {
        try {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)HttpManager.getSSLSocketFactory(), 443));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)25000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
            DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            return client;
        }
        catch (Exception e) {
            return new DefaultHttpClient();
        }
    }

    public static void buildParams(OutputStream baos, WeiboParameters params) throws WeiboException {
        try {
            StringBuilder sb;
            Object value;
            Set<String> keys = params.keySet();
            for (String key : keys) {
                value = params.get(key);
                if (!(value instanceof String)) continue;
                sb = new StringBuilder(100);
                sb.setLength(0);
                sb.append(MP_BOUNDARY).append("\r\n");
                sb.append("content-disposition: form-data; name=\"").append(key).append("\"\r\n\r\n");
                sb.append(params.get(key)).append("\r\n");
                baos.write(sb.toString().getBytes());
            }
            for (String key : keys) {
                value = params.get(key);
                if (value instanceof Bitmap) {
                    sb = new StringBuilder();
                    sb.append(MP_BOUNDARY).append("\r\n");
                    sb.append("content-disposition: form-data; name=\"").append(key).append("\"; filename=\"file\"\r\n");
                    sb.append("Content-Type: application/octet-stream; charset=utf-8\r\n\r\n");
                    baos.write(sb.toString().getBytes());
                    Bitmap bmp = (Bitmap)value;
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                    byte[] bytes = stream.toByteArray();
                    baos.write(bytes);
                    baos.write("\r\n".getBytes());
                    continue;
                }
                if (!(value instanceof ByteArrayOutputStream)) continue;
                sb = new StringBuilder();
                sb.append(MP_BOUNDARY).append("\r\n");
                sb.append("content-disposition: form-data; name=\"").append(key).append("\"; filename=\"file\"\r\n");
                sb.append("Content-Type: application/octet-stream; charset=utf-8\r\n\r\n");
                baos.write(sb.toString().getBytes());
                ByteArrayOutputStream stream = (ByteArrayOutputStream)value;
                baos.write(stream.toByteArray());
                baos.write("\r\n".getBytes());
                stream.close();
            }
            baos.write(("\r\n" + END_MP_BOUNDARY).getBytes());
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
    }

    public static String readRsponse(HttpResponse response) throws WeiboException {
        if (response == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        InputStream inputStream = null;
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        try {
            inputStream = entity.getContent();
            Header header = response.getFirstHeader("Content-Encoding");
            if (header != null && header.getValue().toLowerCase().indexOf("gzip") > -1) {
                inputStream = new GZIPInputStream(inputStream);
            }
            int readBytes = 0;
            byte[] buffer = new byte[8192];
            while ((readBytes = inputStream.read(buffer)) != -1) {
                content.write(buffer, 0, readBytes);
            }
            String result = new String(content.toByteArray(), "UTF-8");
            LogUtil.d(TAG, "readRsponse result : " + result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getBoundry() {
        StringBuffer sb = new StringBuffer();
        int t = 1;
        while (t < 12) {
            long time = System.currentTimeMillis() + (long)t;
            if (time % 3L == 0L) {
                sb.append((char)time % 9);
            } else if (time % 3L == 1L) {
                sb.append((char)(65L + time % 26L));
            } else {
                sb.append((char)(97L + time % 26L));
            }
            ++t;
        }
        return sb.toString();
    }

    private static SSLSocketFactory getSSLSocketFactory() {
        if (sSSLSocketFactory == null) {
            try {
                String keyStoreType = KeyStore.getDefaultType();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(null, null);
                Certificate cnCertificate = HttpManager.getCertificate("cacert_cn.cer");
                Certificate comCertificate = HttpManager.getCertificate("cacert_com.cer");
                keyStore.setCertificateEntry("cnca", cnCertificate);
                keyStore.setCertificateEntry("comca", comCertificate);
                sSSLSocketFactory = new SSLSocketFactoryEx(keyStore);
                LogUtil.d(TAG, "getSSLSocketFactory noraml !!!!!");
            }
            catch (Exception e) {
                e.printStackTrace();
                sSSLSocketFactory = SSLSocketFactory.getSocketFactory();
                LogUtil.d(TAG, "getSSLSocketFactory error default !!!!!");
            }
        }
        return sSSLSocketFactory;
    }

    private static Certificate getCertificate(String name) throws CertificateException, IOException {
        Certificate certificate;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        InputStream certInput = HttpManager.class.getResourceAsStream(name);
        try {
            certificate = cf.generateCertificate(certInput);
        }
        finally {
            if (certInput != null) {
                certInput.close();
            }
        }
        return certificate;
    }

    private static String getTimestamp() {
        long timestamp = System.currentTimeMillis() / 1000L;
        return String.valueOf(timestamp);
    }

    private static String getOauthSign(Context context, String aid, String accessToken, String appKey, String timestamp) {
        StringBuilder part1 = new StringBuilder("");
        if (!TextUtils.isEmpty((CharSequence)aid)) {
            part1.append(aid);
        }
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            part1.append(accessToken);
        }
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            part1.append(appKey);
        }
        return HttpManager.calcOauthSignNative(context, part1.toString(), timestamp);
    }

    private static native String calcOauthSignNative(Context var0, String var1, String var2);
}

