/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.util.AttributeSet;
import android.widget.TextView;

public class LoadingBar
extends TextView {
    private static final int MAX_PROGRESS = 100;
    private int mProgress;
    private int mProgressColor;
    private Paint mPaint;
    private Handler mHander;
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            LoadingBar loadingBar = LoadingBar.this;
            loadingBar.mProgress = loadingBar.mProgress + 1;
            LoadingBar.this.drawProgress(LoadingBar.this.mProgress);
        }
    };

    public LoadingBar(Context context) {
        super(context);
        this.init(context);
    }

    public LoadingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoadingBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mHander = new Handler();
        this.mPaint = new Paint();
        this.initSkin();
    }

    public void initSkin() {
        this.mProgressColor = -11693826;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(this.mProgressColor);
        Rect r = this.getRect();
        canvas.drawRect(r, this.mPaint);
    }

    private Rect getRect() {
        int left = this.getLeft();
        int top = this.getTop();
        int right = this.getLeft() + (this.getRight() - this.getLeft()) * this.mProgress / 100;
        int bottom = this.getBottom();
        return new Rect(0, 0, right - left, bottom - top);
    }

    public void drawProgress(int progress) {
        if (progress < 7) {
            this.mHander.postDelayed(this.mRunnable, 70L);
        } else {
            this.mHander.removeCallbacks(this.mRunnable);
            this.mProgress = progress;
        }
        this.invalidate();
    }
}

