/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelbase.BaseResp;
import com.tencent.mm.sdk.modelmsg.SendAuth;
import com.tencent.mm.sdk.modelmsg.SendMessageToWX;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.sdk.openapi.WXAPIFactory;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.handler.WeixinPreferences;
import com.umeng.socialize.media.WeiXinShareContent;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.Dummy;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.weixin.net.WXAuthUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UMWXHandler
extends UMSSOHandler {
    private static final String TAG = "UMWXHandler";
    private static final int REQUEST_CODE = 10086;
    private static final int REFRESH_TOKEN_EXPIRES = 604800;
    private static final int RESP_TYPE_AUTH = 1;
    private static final int RESP_TYPE_SHARE = 2;
    private static String sScope = "snsapi_userinfo,snsapi_friend,snsapi_message";
    private WeiXinShareContent mShareContent;
    private PlatformConfig.Weixin config;
    private WeixinPreferences weixinPreferences;
    private UMAuthListener mAuthListener;
    private UMShareListener umShareListener;
    private SHARE_MEDIA mTarget = SHARE_MEDIA.WEIXIN;
    private boolean isToCircle = false;
    private Context mcontext;
    private IWXAPI mWXApi;
    private boolean isWXSceneFavorite = false;
    private IWXAPIEventHandler mEventHandler = new IWXAPIEventHandler(){

        public void onResp(BaseResp resp) {
            int type = resp.getType();
            switch (type) {
                case 1: {
                    UMWXHandler.this.onAuthCallback((SendAuth.Resp)resp);
                    break;
                }
                case 2: {
                    UMWXHandler.this.onShareCallback((SendMessageToWX.Resp)resp);
                    break;
                }
            }
        }

        public void onReq(BaseReq req) {
        }
    };

    public void setScope(String ... scope) {
        sScope = TextUtils.join((CharSequence)",", (Object[])scope);
    }

    public void onCreate(Context context, PlatformConfig.Platform p) {
        this.weixinPreferences = new WeixinPreferences(context.getApplicationContext(), "weixin");
        this.config = (PlatformConfig.Weixin)p;
        this.mWXApi = WXAPIFactory.createWXAPI((Context)context.getApplicationContext(), (String)this.config.appId);
        this.mWXApi.registerApp(this.config.appId);
        if (!this.isClientInstalled()) {
            StringBuilder msb = new StringBuilder();
            msb.append("\u8bf7\u5b89\u88c5");
            msb.append(this.mTarget);
            msb.append("\u5ba2\u6237\u7aef");
            if (Config.IsToastTip) {
                Toast.makeText((Context)context, (CharSequence)msb.toString(), (int)0).show();
            }
        }
        this.mcontext = context;
    }

    public void authorize(Activity act, UMAuthListener listener) {
        this.mAuthListener = listener;
        this.mTarget = this.config.getName();
        this.isToCircle = !this.config.getName().toString().equals("WEIXIN");
        SHARE_MEDIA sHARE_MEDIA = this.mTarget = this.isToCircle ? SHARE_MEDIA.WEIXIN_CIRCLE : SHARE_MEDIA.WEIXIN;
        if (this.weixinPreferences.isAuthValid()) {
            String refreshToken;
            if (this.weixinPreferences.isAccessTokenAvailable()) {
                refreshToken = this.weixinPreferences.getRefreshToken();
                String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + this.config.appId + "&grant_type=refresh_token&refresh_token=" + refreshToken;
                this.loadOauthData(url);
            }
            refreshToken = this.weixinPreferences.getRefreshToken();
            Map<String, String> map = this.getAuthWithRefreshToken(refreshToken);
            this.mAuthListener.onComplete(SHARE_MEDIA.WEIXIN, 0, map);
        } else {
            SendAuth.Req req = new SendAuth.Req();
            req.scope = sScope;
            req.state = "none";
            this.mWXApi.sendReq((BaseReq)req);
        }
    }

    public boolean isAuthorize(Context mContext) {
        return this.weixinPreferences.isAuth();
    }

    private void loadOauthData(String url) {
        String response = WXAuthUtils.request(url);
        Bundle bundle = this.parseAuthData(response);
        this.weixinPreferences.setBundle(bundle);
        this.mAuthListener.onComplete(this.config.getName(), 0, null);
    }

    private Bundle parseAuthData(String response) {
        Bundle bundle = new Bundle();
        if (TextUtils.isEmpty((CharSequence)response)) {
            return bundle;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            Iterator iterator = jsonObject.keys();
            String key = "";
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                bundle.putString(key, jsonObject.optString(key));
            }
            bundle.putString("uid", bundle.getString("openid"));
            bundle.putLong("refresh_token_expires", 604800L);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    private Map<String, String> getAuthWithRefreshToken(String refresh_token) {
        StringBuilder authURL = new StringBuilder();
        authURL.append("https://api.weixin.qq.com/sns/oauth2/refresh_token?");
        authURL.append("appid=").append(this.config.appId);
        authURL.append("&grant_type=refresh_token");
        authURL.append("&refresh_token=").append(refresh_token);
        String response = WXAuthUtils.request(authURL.toString());
        Map map = null;
        try {
            map = SocializeUtils.jsonToMap((String)response);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private void getAuthWithCode(String code, final UMAuthListener listener) {
        final StringBuilder authURL = new StringBuilder();
        authURL.append("https://api.weixin.qq.com/sns/oauth2/access_token?");
        authURL.append("appid=").append(this.config.appId);
        authURL.append("&secret=").append(this.config.appSecret);
        authURL.append("&code=").append(code);
        authURL.append("&grant_type=authorization_code");
        new Thread(new Runnable(){

            @Override
            public void run() {
                String response = WXAuthUtils.request(authURL.toString());
                Map<String, String> map = null;
                try {
                    map = SocializeUtils.jsonToMap((String)response);
                    if (map == null || map.size() == 0) {
                        map = UMWXHandler.this.weixinPreferences.getmap();
                    }
                    Bundle bundle = UMWXHandler.this.parseAuthData(response);
                    UMWXHandler.this.weixinPreferences.setBundle(bundle);
                    final Map<String, String> finalMap = map;
                    QueuedWork.runInMain((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UMWXHandler.this.uploadAuthData(finalMap);
                            listener.onComplete(SHARE_MEDIA.WEIXIN, 0, finalMap);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public boolean isInstall(Context context) {
        return this.isClientInstalled();
    }

    protected void onAuthCallback(SendAuth.Resp resp) {
        UMAuthListener authListener = (UMAuthListener)Dummy.get(UMAuthListener.class, (Object)this.mAuthListener);
        if (resp.errCode == 0) {
            this.getAuthWithCode(resp.code, authListener);
        } else if (resp.errCode == -2) {
            authListener.onCancel(SHARE_MEDIA.WEIXIN, 0);
        } else {
            CharSequence err = TextUtils.concat((CharSequence[])new CharSequence[]{"weixin auth error (", String.valueOf(resp.errCode), "):", resp.errStr});
            SocializeException ex = new SocializeException(err.toString());
            authListener.onError(SHARE_MEDIA.WEIXIN, 0, (Throwable)ex);
        }
    }

    public void deleteAuth(Context context, UMAuthListener listener) {
        if (!this.isInstall(context)) {
            return;
        }
        this.weixinPreferences.delete();
        listener.onComplete(SHARE_MEDIA.WEIXIN, 1, null);
    }

    public boolean isSupportAuth() {
        return true;
    }

    public int getRequestCode() {
        if (this.isToCircle) {
            return 10085;
        }
        return 10086;
    }

    public void getPlatformInfo(Activity act, final UMAuthListener listener) {
        String uid = this.weixinPreferences.getUID();
        String accessToken = this.weixinPreferences.getAccessToken();
        if (TextUtils.isEmpty((CharSequence)uid) || TextUtils.isEmpty((CharSequence)accessToken)) {
            Log.e((String)TAG, (String)"please check had authed...");
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onComplete(UMWXHandler.this.isToCircle ? SHARE_MEDIA.WEIXIN_CIRCLE : SHARE_MEDIA.WEIXIN, 2, null);
                }
            });
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/sns/userinfo?access_token=");
        builder.append(accessToken).append("&openid=").append(uid);
        builder.append("&lang=zh_CN");
        String jsonStr = WXAuthUtils.request(builder.toString());
        final Map<String, String> map = this.parseUserInfo(jsonStr);
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                listener.onComplete(UMWXHandler.this.isToCircle ? SHARE_MEDIA.WEIXIN_CIRCLE : SHARE_MEDIA.WEIXIN, 2, map);
            }
        });
    }

    private void uploadAuthData(final Map<String, String> bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlatformTokenUploadReq req = new PlatformTokenUploadReq(UMWXHandler.this.mcontext);
                req.addStringParams("to", "wxsession");
                req.addStringParams("usid", (String)bundle.get("uid"));
                req.addStringParams("access_token", (String)bundle.get("access_token"));
                req.addStringParams("refresh_token", (String)bundle.get("refresh_token"));
                req.addStringParams("expires_in", (String)bundle.get("expires_in"));
                req.addStringParams("app_id", ((UMWXHandler)UMWXHandler.this).config.appId);
                req.addStringParams("app_secret", ((UMWXHandler)UMWXHandler.this).config.appSecret);
                PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                Log.e((String)("upload token resp = " + resp));
            }
        }).start();
    }

    private Map<String, String> parseUserInfo(String result) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JSONObject jsonObject = new JSONObject(result);
            boolean error = jsonObject.has("errcode");
            if (error) {
                Log.e((String)TAG, (String)(result + ""));
                map.put("errcode", jsonObject.getString("errcode"));
                return map;
            }
            map.put("openid", jsonObject.opt("openid").toString());
            map.put("nickname", jsonObject.opt("nickname").toString());
            map.put("language", jsonObject.opt("language").toString());
            map.put("city", jsonObject.opt("city").toString());
            map.put("province", jsonObject.opt("province").toString());
            map.put("country", jsonObject.opt("country").toString());
            map.put("headimgurl", jsonObject.opt("headimgurl").toString());
            map.put("unionid", jsonObject.opt("unionid").toString());
            map.put("sex", jsonObject.opt("sex").toString());
            JSONArray jsonArray = jsonObject.getJSONArray("privilege");
            int len = jsonArray.length();
            if (len > 0) {
                String[] privileges = new String[len];
                for (int i = 0; i < len; ++i) {
                    privileges[i] = jsonArray.get(i).toString();
                }
                map.put("privilege", privileges.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
        return map;
    }

    public boolean share(Activity activity, ShareContent content, UMShareListener listener) {
        this.mTarget = this.config.getName();
        this.isToCircle = !this.config.getName().toString().equals("WEIXIN");
        SHARE_MEDIA sHARE_MEDIA = this.mTarget = this.isToCircle ? SHARE_MEDIA.WEIXIN_CIRCLE : SHARE_MEDIA.WEIXIN;
        if (!this.isClientInstalled()) {
            return false;
        }
        if (!this.mWXApi.isWXAppSupportAPI()) {
            if (Config.IsToastTip) {
                Toast.makeText((Context)activity, (CharSequence)"\u4f60\u5b89\u88c5\u7684\u5fae\u4fe1\u7248\u672c\u4e0d\u652f\u6301\u5f53\u524dAPI", (int)0).show();
            }
            return false;
        }
        this.mShareContent = new WeiXinShareContent(content);
        if (this.mShareContent != null) {
            this.mShareContent.parseMediaType();
            if (this.mShareContent.mShareType == "emoji" && this.isToCircle) {
                Toast.makeText((Context)activity, (CharSequence)"\u5fae\u4fe1\u670b\u53cb\u5708\u4e0d\u652f\u6301\u8868\u60c5\u5206\u4eab...", (int)0).show();
                return false;
            }
        }
        this.umShareListener = listener;
        return this.shareTo(new WeiXinShareContent(content));
    }

    public boolean isClientInstalled() {
        return this.mWXApi.isWXAppInstalled();
    }

    public boolean shareTo(WeiXinShareContent shareContent) {
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.transaction = this.buildTransaction(this.mShareContent.mShareType);
        req.message = shareContent.getWxMediaMessage();
        switch (this.mTarget) {
            case WEIXIN: {
                req.scene = 0;
                break;
            }
            case WEIXIN_CIRCLE: {
                req.scene = 1;
                break;
            }
            default: {
                req.scene = 2;
            }
        }
        boolean sendReq = this.mWXApi.sendReq((BaseReq)req);
        return sendReq;
    }

    protected void onShareCallback(SendMessageToWX.Resp resp) {
        switch (resp.errCode) {
            case 0: {
                this.umShareListener.onResult(this.mTarget);
                break;
            }
            case -2: {
                this.umShareListener.onCancel(this.mTarget);
                break;
            }
            case -3: 
            case -1: {
                this.umShareListener.onError(this.mTarget, (Throwable)new SocializeException(resp.errCode, resp.errStr));
                break;
            }
            default: {
                Log.d((String)TAG, (String)"\u5fae\u4fe1\u53d1\u9001 -- \u672a\u77e5\u9519\u8bef.");
            }
        }
    }

    public IWXAPIEventHandler getWXEventHandler() {
        return this.mEventHandler;
    }

    public IWXAPI getWXApi() {
        return this.mWXApi;
    }

    private String buildTransaction(String type) {
        return type == null ? String.valueOf(System.currentTimeMillis()) : type + System.currentTimeMillis();
    }

    public void setWXSceneFavorite(boolean flag) {
        this.isWXSceneFavorite = flag;
    }

    class ShareListenerWrapper
    implements UMShareListener {
        private UMShareListener mShareListener;

        public ShareListenerWrapper(UMShareListener listener) {
            this.mShareListener = listener;
        }

        public void onResult(SHARE_MEDIA platform) {
            if (this.mShareListener != null) {
                this.mShareListener.onResult(platform);
            }
        }

        public void onError(SHARE_MEDIA platform, Throwable t) {
            if (this.mShareListener != null) {
                this.mShareListener.onError(platform, t);
            }
        }

        public void onCancel(SHARE_MEDIA platform) {
            if (this.mShareListener != null) {
                this.mShareListener.onCancel(platform);
            }
        }
    }

    class AuthListenerWrapper
    implements UMAuthListener {
        private UMAuthListener mAuthListener;

        public AuthListenerWrapper(UMAuthListener listener) {
            this.mAuthListener = listener;
        }

        public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
            if (data != null) {
                UMWXHandler.this.weixinPreferences.setAuthData(data).commit();
            }
            if (this.mAuthListener != null) {
                this.mAuthListener.onComplete(platform, action, data);
            }
        }

        public void onError(SHARE_MEDIA platform, int action, Throwable t) {
            if (this.mAuthListener != null) {
                this.mAuthListener.onError(platform, action, t);
            }
        }

        public void onCancel(SHARE_MEDIA platform, int action) {
            if (this.mAuthListener != null) {
                this.mAuthListener.onCancel(platform, action);
            }
        }
    }
}

