/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.cmd;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Pair;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.cmd.AppInstallCmd;
import com.sina.weibo.sdk.cmd.CmdExecutor;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.NetUtils;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.NetworkHelper;
import com.sina.weibo.sdk.utils.ResourceManager;
import com.sina.weibo.sdk.utils.SDKNotification;
import java.io.File;
import java.util.List;

class AppInstallCmdExecutor
implements CmdExecutor<AppInstallCmd> {
    private static final String WB_APK_FILE_DIR = Environment.getExternalStorageDirectory() + "/Android/org_share_data/";
    private static final String TAG = AppInstallCmdExecutor.class.getName();
    private static final int MESSAGE_DO_CMD = 1;
    private static final int MESSAGE_QUIT_LOOP = 2;
    private Context mContext;
    private HandlerThread thread;
    private Looper mLooper;
    private InstallHandler mHandler;
    private boolean isStarted = false;

    public AppInstallCmdExecutor(Context ctx) {
        this.mContext = ctx.getApplicationContext();
    }

    private void handleCmd(AppInstallCmd cmd) {
        boolean needActivate = AppInstallCmdExecutor.needActivate(this.mContext, cmd);
        if (!needActivate) {
            return;
        }
        String dir = WB_APK_FILE_DIR;
        String downloadUrl = cmd.getDownloadUrl();
        long versionCode = cmd.getAppVersion();
        Pair<Integer, File> pair = AppInstallCmdExecutor.walkDir(this.mContext, dir, cmd);
        if (pair != null && pair.second != null && (long)((Integer)pair.first).intValue() >= versionCode) {
            AppInstallCmdExecutor.showNotification(this.mContext, cmd, ((File)pair.second).getAbsolutePath());
        } else if (NetworkHelper.isWifiValid(this.mContext) && !TextUtils.isEmpty((CharSequence)downloadUrl)) {
            String filePath = "";
            try {
                String redirectUrl = NetUtils.internalGetRedirectUri(this.mContext, downloadUrl, "GET", new WeiboParameters(""));
                String fileName = AppInstallCmdExecutor.generateSaveFileName(redirectUrl);
                if (TextUtils.isEmpty((CharSequence)fileName) || !fileName.endsWith(".apk")) {
                    LogUtil.e(TAG, "redirectDownloadUrl is illeagle");
                    return;
                }
                try {
                    filePath = NetUtils.internalDownloadFile(this.mContext, redirectUrl, dir, fileName);
                }
                catch (WeiboException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (!TextUtils.isEmpty((CharSequence)filePath)) {
                    AppInstallCmdExecutor.showNotification(this.mContext, cmd, filePath);
                }
            }
        }
    }

    private static boolean needActivate(Context ctx, AppInstallCmd cmd) {
        List<String> packages = cmd.getAppPackage();
        if (packages == null || packages.size() == 0 || TextUtils.isEmpty((CharSequence)cmd.getAppSign()) || TextUtils.isEmpty((CharSequence)cmd.getDownloadUrl()) || TextUtils.isEmpty((CharSequence)cmd.getNotificationText())) {
            return false;
        }
        if (packages.contains("com.sina.weibo")) {
            WeiboAppManager.WeiboInfo mWeiboInfo = WeiboAppManager.getInstance(ctx).getWeiboInfo();
            return mWeiboInfo == null || !mWeiboInfo.isLegal();
        }
        for (String packageName : packages) {
            boolean installed = AppInstallCmdExecutor.checkApkInstalled(ctx, packageName);
            if (!installed) continue;
            return false;
        }
        return true;
    }

    private static boolean checkApkInstalled(Context ctx, String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        try {
            PackageInfo info = ctx.getPackageManager().getPackageInfo(packageName, 1);
            return info != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public void start() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.thread = new HandlerThread("");
        this.thread.start();
        this.mLooper = this.thread.getLooper();
        this.mHandler = new InstallHandler(this.mLooper);
    }

    public void stop() {
        if (this.thread == null || this.mHandler == null) {
            LogUtil.w(TAG, "no thread running. please call start method first!");
            return;
        }
        Message msg = this.mHandler.obtainMessage();
        msg.what = 2;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public boolean doExecutor(AppInstallCmd cmd) {
        if (this.thread == null || this.mHandler == null) {
            throw new RuntimeException("no thread running. please call start method first!");
        }
        if (cmd != null) {
            Message msg = this.mHandler.obtainMessage();
            msg.what = 1;
            msg.obj = cmd;
            this.mHandler.sendMessage(msg);
        }
        return false;
    }

    private static Pair<Integer, File> walkDir(Context ctx, String dir, AppInstallCmd cmd) {
        if (TextUtils.isEmpty((CharSequence)dir)) {
            return null;
        }
        File dirFile = new File(dir);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return null;
        }
        File[] files = dirFile.listFiles();
        if (files == null) {
            return null;
        }
        int newestVersion = 0;
        File weiboApkFile = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            PackageManager packageManager;
            PackageInfo pkgInfo;
            boolean isSpecifiedApk;
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file.isFile() && fileName.endsWith(".apk") && (isSpecifiedApk = AppInstallCmdExecutor.isSpecifiedApk(pkgInfo = (packageManager = ctx.getPackageManager()).getPackageArchiveInfo(file.getAbsolutePath(), 64), cmd.getAppPackage(), cmd.getAppSign())) && pkgInfo.versionCode > newestVersion) {
                newestVersion = pkgInfo.versionCode;
                weiboApkFile = file;
            }
            ++n2;
        }
        return new Pair((Object)newestVersion, weiboApkFile);
    }

    private static boolean isSpecifiedApk(PackageInfo pkgInfo, List<String> packageNames, String appSign) {
        boolean packageChecked = false;
        for (String packageName : packageNames) {
            if (!AppInstallCmdExecutor.checkPackageName(pkgInfo, packageName)) continue;
            packageChecked = true;
            break;
        }
        boolean signChecked = AppInstallCmdExecutor.checkApkSign(pkgInfo, appSign);
        return packageChecked && signChecked;
    }

    private static boolean checkPackageName(PackageInfo pkgInfo, String packageName) {
        if (pkgInfo == null) {
            return false;
        }
        String pkgName = pkgInfo.packageName;
        return packageName.equals(pkgName);
    }

    private static boolean checkApkSign(PackageInfo pkgInfo, String appSign) {
        if (pkgInfo == null) {
            return false;
        }
        if (pkgInfo.signatures == null) {
            return Build.VERSION.SDK_INT < 11;
        }
        String md5Sign = "";
        int j = 0;
        while (j < pkgInfo.signatures.length) {
            byte[] str = pkgInfo.signatures[j].toByteArray();
            if (str != null) {
                md5Sign = MD5.hexdigest(str);
            }
            ++j;
        }
        if (md5Sign == null) {
            return false;
        }
        return md5Sign.equals(appSign);
    }

    private static String generateSaveFileName(String downloadUrl) {
        String fileName = "";
        int index = downloadUrl.lastIndexOf("/");
        if (index != -1) {
            fileName = downloadUrl.substring(index + 1, downloadUrl.length());
        }
        return fileName;
    }

    private static void showNotification(Context ctx, AppInstallCmd cmd, String apkPath) {
        SDKNotification.SDKNotificationBuilder.buildUpon().setNotificationContent(cmd.getNotificationText()).setNotificationPendingIntent(AppInstallCmdExecutor.buildInstallApkIntent(ctx, apkPath)).setNotificationTitle(AppInstallCmdExecutor.getNotificationTitle(ctx, cmd.getNotificationTitle())).setTickerText(cmd.getNotificationText()).build(ctx).show(1);
    }

    private static PendingIntent buildInstallApkIntent(Context ctx, String filePath) {
        PendingIntent pendingIntent = null;
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            Intent intentInstall = new Intent("android.intent.action.VIEW");
            Uri localUri = Uri.fromFile((File)new File(filePath));
            intentInstall.setDataAndType(localUri, "application/vnd.android.package-archive");
            pendingIntent = PendingIntent.getActivity((Context)ctx, (int)0, (Intent)intentInstall, (int)16);
        } else {
            Intent intent = new Intent();
            pendingIntent = PendingIntent.getActivity((Context)ctx, (int)0, (Intent)intent, (int)16);
        }
        return pendingIntent;
    }

    private static String getNotificationTitle(Context ctx, String title) {
        if (TextUtils.isEmpty((CharSequence)title)) {
            return ResourceManager.getString(ctx, "Weibo", "\u5fae\u535a", "\u5fae\u535a");
        }
        return title;
    }

    private class InstallHandler
    extends Handler {
        public InstallHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            int msgWhat = msg.what;
            switch (msgWhat) {
                case 1: {
                    AppInstallCmdExecutor.this.handleCmd((AppInstallCmd)msg.obj);
                    break;
                }
                case 2: {
                    AppInstallCmdExecutor.this.mLooper.quit();
                    AppInstallCmdExecutor.this.isStarted = false;
                    break;
                }
            }
        }
    }

    private static final class NOTIFICATION_CONSTANTS {
        private static final int NOTIFICATIONID = 1;
        private static final String WEIBO = "Weibo";
        private static final String WEIBO_ZH_CN = "\u5fae\u535a";
        private static final String WEIBO_ZH_TW = "\u5fae\u535a";

        private NOTIFICATION_CONSTANTS() {
        }
    }
}

