/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import android.text.TextUtils;
import com.sina.weibo.sdk.utils.LogUtil;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.protocol.HttpContext;

public abstract class CustomRedirectHandler
implements RedirectHandler {
    private static final String TAG = CustomRedirectHandler.class.getCanonicalName();
    private static final int MAX_REDIRECT_COUNT = 15;
    int redirectCount;
    String redirectUrl;
    private String tempRedirectUrl;

    public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
        LogUtil.d(TAG, "CustomRedirectHandler getLocationURI getRedirectUrl : " + this.tempRedirectUrl);
        if (!TextUtils.isEmpty((CharSequence)this.tempRedirectUrl)) {
            return URI.create(this.tempRedirectUrl);
        }
        return null;
    }

    public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 301 || statusCode == 302) {
            this.tempRedirectUrl = response.getFirstHeader("Location").getValue();
            if (!TextUtils.isEmpty((CharSequence)this.tempRedirectUrl) && this.redirectCount < 15 && this.shouldRedirectUrl(this.tempRedirectUrl)) {
                ++this.redirectCount;
                return true;
            }
        } else if (statusCode == 200) {
            this.redirectUrl = this.tempRedirectUrl;
        } else {
            this.onReceivedException();
        }
        return false;
    }

    public abstract boolean shouldRedirectUrl(String var1);

    public abstract void onReceivedException();

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public int getRedirectCount() {
        return this.redirectCount;
    }
}

