/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.Display;
import android.view.WindowManager;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.common.SocializeConstants;
import com.umeng.socialize.utils.BitmapUtils;
import com.umeng.socialize.utils.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class SocializeUtils {
    protected static final String TAG = "SocializeUtils";
    public static Set<Uri> deleteUris = new HashSet<Uri>();
    private static Pattern mDoubleByte_Pattern = null;
    private static int smDip = 0;

    public static String getAppkey(Context context) {
        String string = SocializeConstants.APPKEY;
        if (TextUtils.isEmpty((CharSequence)string)) {
            try {
                PackageManager packageManager = context.getPackageManager();
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
                if (applicationInfo != null) {
                    Object object = applicationInfo.metaData.get("UMENG_APPKEY");
                    if (object != null) {
                        string = object.toString();
                    } else {
                        Log.i("com.umeng.socialize", "Could not read UMENG_APPKEY meta-data from AndroidManifest.xml.");
                    }
                }
            }
            catch (Exception exception) {
                Log.i("com.umeng.socialize", "Could not read UMENG_APPKEY meta-data from AndroidManifest.xml.", exception);
            }
        }
        return string;
    }

    public static void safeCloseDialog(Dialog dialog) {
        try {
            Activity activity;
            if (dialog != null && dialog.isShowing() && ((activity = dialog.getOwnerActivity()) == null || !activity.isFinishing())) {
                dialog.dismiss();
                dialog = null;
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            Log.e(TAG, "dialog dismiss error", (Exception)((Object)badTokenException));
        }
    }

    public static void safeShowDialog(Dialog dialog) {
        try {
            Activity activity;
            if (dialog != null && !dialog.isShowing() && (activity = dialog.getOwnerActivity()) != null && !activity.isFinishing()) {
                dialog.show();
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            Log.e(TAG, "dialog show error", (Exception)((Object)badTokenException));
        }
    }

    public static Bundle parseUrl(String string) {
        try {
            URL uRL = new URL(string);
            Bundle bundle = SocializeUtils.decodeUrl(uRL.getQuery());
            bundle.putAll(SocializeUtils.decodeUrl(uRL.getRef()));
            return bundle;
        }
        catch (MalformedURLException malformedURLException) {
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String string) {
        Bundle bundle = new Bundle();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("&")) {
                String[] stringArray2 = string2.split("=");
                bundle.putString(URLDecoder.decode(stringArray2[0]), URLDecoder.decode(stringArray2[1]));
            }
        }
        return bundle;
    }

    public static int countContentLength(String string) {
        string = string.trim();
        int n = 0;
        int n2 = 0;
        Pattern pattern = SocializeUtils.getDoubleBytePattern();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ++n2;
        }
        n = string.length() - n2;
        n2 = n % 2 != 0 ? (n2 += (n + 1) / 2) : (n2 += n / 2);
        return n2;
    }

    private static Pattern getDoubleBytePattern() {
        if (mDoubleByte_Pattern == null) {
            mDoubleByte_Pattern = Pattern.compile("[^\\x00-\\xff]");
        }
        return mDoubleByte_Pattern;
    }

    public static Object[] readSIMCard(Context context) {
        try {
            Object[] objectArray = new Object[3];
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            objectArray[0] = false;
            switch (telephonyManager.getSimState()) {
                case 1: {
                    objectArray[1] = "\u65e0\u5361";
                    break;
                }
                case 0: {
                    objectArray[0] = true;
                    objectArray[1] = "\u672a\u77e5\u72b6\u6001";
                    break;
                }
                case 4: {
                    objectArray[1] = "\u9700\u8981NetworkPIN\u89e3\u9501";
                    break;
                }
                case 2: {
                    objectArray[1] = "\u9700\u8981PIN\u89e3\u9501";
                    break;
                }
                case 3: {
                    objectArray[1] = "\u9700\u8981PUK\u89e3\u9501";
                    break;
                }
                case 5: {
                    objectArray[0] = true;
                    objectArray[1] = "\u826f\u597d";
                }
            }
            return objectArray;
        }
        catch (Exception exception) {
            Log.e(TAG, "cannot read SIM card. [" + exception.toString() + "]");
            return null;
        }
    }

    public static boolean isGoogleMapExist() {
        try {
            Class.forName("com.google.android.maps.MapActivity");
            return true;
        }
        catch (Exception exception) {
            Log.w(TAG, "The device has no google map lib!");
            return false;
        }
    }

    public static int[] getFloatWindowSize(Context context) {
        ResContainer resContainer = ResContainer.get(context);
        Resources resources = context.getResources();
        int[] nArray = new int[]{(int)resources.getDimension(resContainer.dimen("umeng_socialize_pad_window_width")), (int)resources.getDimension(resContainer.dimen("umeng_socialize_pad_window_height"))};
        return nArray;
    }

    public static boolean isFloatWindowStyle(Context context) {
        if (SocializeConstants.SUPPORT_PAD) {
            if (smDip == 0) {
                int n;
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                int n2 = display.getWidth();
                int n3 = n2 > (n = display.getHeight()) ? n : n2;
                DisplayMetrics displayMetrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getMetrics(displayMetrics);
                smDip = (int)((float)n3 / displayMetrics.density + 0.5f);
            }
            int n = context.getResources().getConfiguration().screenLayout;
            if ((n &= 0xF) >= 3 && smDip >= 550) {
                return true;
            }
        }
        return false;
    }

    public static Uri insertImage(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string) || !new File(string).exists()) {
            return null;
        }
        try {
            String string2 = MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)string, (String)"umeng_social_shareimg", null);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            Uri uri = Uri.parse((String)string2);
            return uri;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e("com.umeng.socialize", "", illegalArgumentException);
        }
        catch (Exception exception) {
            Log.e("com.umeng.socialize", "", exception);
        }
        return null;
    }

    public static void deleteUriImage(Context context, Set<Uri> set) {
        String string = BitmapUtils.PATH + "image_uri_cache";
        Set set2 = (Set)SocializeUtils.getObject(string);
        if (set2 != null && set2.size() > 0) {
            for (String string2 : set2) {
                set.add(Uri.parse((String)string2));
            }
        }
        if (set != null && set.size() > 0) {
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                context.getContentResolver().delete((Uri)iterator.next(), null, null);
            }
            set.clear();
        } else if (set == null) {
            set = new HashSet<Uri>();
        }
    }

    public static void saveObject(Object object, String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getObject(String string) {
        ObjectInputStream objectInputStream = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                T t = null;
                return t;
            }
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            Object object = objectInputStream.readObject();
            if (object != null) {
                Object object2 = object;
                return (T)object2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    public static int dip2Px(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 * f3 + 0.5f);
    }

    public static String reverse(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        for (int j = cArray.length - 1; j >= 0; --j) {
            stringBuilder.append(cArray[j]);
        }
        return stringBuilder.toString();
    }

    public static Pair<String, String> resolveActivity(Context context, String string, String string2) {
        Pair pair = null;
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("image/*");
        List list = context.getPackageManager().queryIntentActivities(intent, 0);
        if (!list.isEmpty()) {
            for (ResolveInfo resolveInfo : list) {
                boolean bl = resolveInfo.activityInfo.packageName.toLowerCase().contains(string);
                boolean bl2 = resolveInfo.activityInfo.name.toLowerCase().contains(string2);
                if (!bl && !bl2) continue;
                String string3 = resolveInfo.activityInfo.parentActivityName;
                String string4 = resolveInfo.activityInfo.name;
                pair = new Pair((Object)string3, (Object)string4);
                break;
            }
        }
        return pair;
    }

    public static Map<String, String> jsonToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, jSONObject.get(string2) + "");
            }
        }
        catch (Exception exception) {
            Log.e("weixin", "jsontomap fail=" + exception);
        }
        return hashMap;
    }
}

