/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.common.SocializeConstants;
import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.net.utils.SocializeProtocolConstants;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SocializeNetUtils {
    private static final String TAG = "SocializeNetUtils";

    public static String generateGetURL(String string, Map<String, Object> map) {
        if (TextUtils.isEmpty((CharSequence)string) || map == null || map.size() == 0) {
            return string;
        }
        if (!string.endsWith("?")) {
            string = string + "?";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = map.keySet();
        for (String string2 : set) {
            if (map.get(string2) == null) continue;
            stringBuilder = stringBuilder.append(string2 + "=" + URLEncoder.encode(map.get(string2).toString()) + "&");
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        try {
            String string2;
            string2 = stringBuilder.substring(0, stringBuilder.length() - 1).toString();
            Log.d(TAG, "##### \u672a\u52a0\u5bc6\u53c2\u6570 : " + string2);
            String string3 = AesHelper.encryptNoPadding(string2, "UTF-8");
            String string4 = "ud_get=" + string3;
            stringBuilder2.append(string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Log.d(TAG, "#### \u5b8c\u6574\u8bf7\u6c42\u94fe\u63a5 : " + stringBuilder2.toString());
        return stringBuilder2.toString();
    }

    public static Map<String, Object> getBaseQuery(Context context) {
        Object object;
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = DeviceConfig.getDeviceId(context);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            hashMap.put("imei", string2);
            hashMap.put("md5imei", AesHelper.md5(string2));
        }
        if (TextUtils.isEmpty((CharSequence)(string = DeviceConfig.getMac(context)))) {
            Log.w(TAG, "Get MacAddress failed. Check permission android.permission.ACCESS_WIFI_STATE [" + DeviceConfig.checkPermission(context, "android.permission.ACCESS_WIFI_STATE") + "]");
        } else {
            hashMap.put("mac", string);
        }
        if (!TextUtils.isEmpty((CharSequence)SocializeConstants.UID)) {
            hashMap.put("uid", SocializeConstants.UID);
        }
        try {
            object = DeviceConfig.getNetworkAccessMode(context);
            hashMap.put("en", object[0]);
        }
        catch (Exception exception) {
            hashMap.put("en", "Unknown");
        }
        hashMap.put("de", Build.MODEL);
        hashMap.put("sdkv", "5.0.0");
        hashMap.put("os", "Android");
        hashMap.put("dt", System.currentTimeMillis());
        object = SocializeUtils.getAppkey(context);
        if (TextUtils.isEmpty((CharSequence)object)) {
            throw new SocializeException("No found appkey.");
        }
        hashMap.put("ak", object);
        hashMap.put(SocializeProtocolConstants.PROTOCOL_VERSION, "2.0");
        if (!TextUtils.isEmpty((CharSequence)Config.EntityKey)) {
            hashMap.put("ek", Config.EntityKey);
            Log.v("10.13", "ek = " + Config.EntityKey);
        }
        if (!TextUtils.isEmpty((CharSequence)Config.SessionId)) {
            hashMap.put("sid", Config.SessionId);
        }
        try {
            hashMap.put("tp", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getNetData(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = (InputStream)new URL(string).openConnection().getContent();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (Exception exception) {
            Log.e("xxxxx e=" + exception);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            block37: {
                if (inputStream == null) break block37;
                try {
                    inputStream.close();
                    if (byteArrayOutputStream == null) break block37;
                }
                catch (IOException iOException) {
                    if (byteArrayOutputStream == null) break block37;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException2) {}
                    break block37;
                    catch (Throwable throwable) {
                        if (byteArrayOutputStream == null) throw throwable;
                        try {
                            byteArrayOutputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException3) {}
                    }
                }
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean startWithHttp(String string) {
        return string.startsWith("http://") || string.startsWith("https://");
    }
}

