/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.open.yyb;

import android.content.Context;
import android.graphics.Color;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tencent.open.yyb.a;

public class TitleBar
extends RelativeLayout {
    public static final float TITLEBAR_HEIGHT = 51.0f;
    public static final float BACKBTN_LEFT_MARGIN = 20.0f;
    public static final float SHAREBTN_RIGHT_MARGIN = 10.0f;
    private static final String SOURCE_TITLEBAR = "yyb_topbar.9.png";
    private static final String SOURCE_BACK_BTN = "yyb_icon_back.png";
    private static final String SOURCE_MORE_BTN = "yyb_appdetail_showmore.png";
    private static final float BACK_PADDING_LEFT = 15.0f;
    private static final float BACK_PADDING_TOP = 7.0f;
    private static final float BACK_PADDING_RIGHT = 20.0f;
    private static final float BACK_PADDING_BOTTOM = 7.0f;
    private static final float BACK_BTN_WIDTH = 11.0f;
    private static final float BACK_BTN_HEIGHT = 18.0f;
    private static final float SHARE_BTN_SIZE = 52.0f;
    private static final int ID_BACK_BTN = 10000;
    private float density;
    private ImageView backBtn;
    private ImageView shareBtn;
    private TextView title;
    private RelativeLayout backLayout;

    public TitleBar(Context context) {
        super(context);
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        this.density = displayMetrics.density;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, this.dip2px(51.0f));
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setBackgroundDrawable(a.a(SOURCE_TITLEBAR, context));
        this.initBackLayout();
        this.initShareBtn();
    }

    public void setTitle(String string) {
        this.title.setText((CharSequence)string);
    }

    private void initBackLayout() {
        this.backLayout = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -1);
        this.backLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.backLayout);
        this.initBackBtn();
        this.initTitle();
    }

    private void initBackBtn() {
        this.backBtn = new ImageView(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.dip2px(11.0f), this.dip2px(18.0f));
        layoutParams.addRule(15);
        layoutParams.leftMargin = this.dip2px(20.0f);
        this.backBtn.setId(10000);
        this.backBtn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.backBtn.setClickable(true);
        this.backBtn.setBackgroundDrawable(a.a(SOURCE_BACK_BTN, this.getContext()));
        this.backBtn.setPadding(this.dip2px(15.0f), this.dip2px(7.0f), this.dip2px(20.0f), this.dip2px(7.0f));
        this.backLayout.addView((View)this.backBtn);
    }

    private void initTitle() {
        this.title = new TextView(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(15);
        layoutParams.addRule(1, 10000);
        layoutParams.leftMargin = this.dip2px(20.0f);
        this.title.setTextColor(Color.parseColor((String)"#fefefe"));
        this.title.setTextSize(20.0f);
        this.title.setShadowLayer(2.0f, 0.0f, 2.0f, Color.parseColor((String)"#2E000000"));
        this.backLayout.addView((View)this.title, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initShareBtn() {
        this.shareBtn = new ImageView(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.dip2px(52.0f), this.dip2px(52.0f));
        layoutParams.addRule(15);
        layoutParams.addRule(11);
        WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        this.shareBtn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.shareBtn.setClickable(true);
        this.shareBtn.setBackgroundDrawable(a.a(SOURCE_MORE_BTN, this.getContext()));
        this.addView((View)this.shareBtn);
    }

    public RelativeLayout getBackBtn() {
        return this.backLayout;
    }

    public ImageView getSharBtn() {
        return this.shareBtn;
    }

    private int dip2px(float f2) {
        return (int)(f2 * this.density + 0.5f);
    }
}

